/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sejda.commons.util.IOUtils;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfMixFragment;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfMixInput;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDPage;

public class PdfAlternateMixer
extends PDDocumentHandler {
    private List<PdfMixFragment> mixFragments = new ArrayList<PdfMixFragment>();

    /*
     * WARNING - void declaration
     */
    public void mix(List<PdfMixInput> inputs, TaskExecutionContext executionContext) throws TaskException {
        this.setCreatorOnPDDocument();
        for (PdfMixInput pdfMixInput : inputs) {
            this.mixFragments.add(PdfMixFragment.newInstance(pdfMixInput));
        }
        int maxNumberOfPages = 0;
        for (PdfMixFragment fragment : this.mixFragments) {
            maxNumberOfPages = Math.max(fragment.getNumberOfPages(), maxNumberOfPages);
        }
        boolean bl = false;
        int maxSteps = this.mixFragments.size() * maxNumberOfPages + 1;
        ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)executionContext.notifiableTaskMetadata()).progressUndetermined();
        while (this.mixFragments.stream().anyMatch(PdfMixFragment::hasNotReachedTheEnd)) {
            void var4_8;
            this.mixFragments.stream().filter(PdfMixFragment::hasNextPage).forEach(f -> {
                for (int i = 0; i < f.getStep() && f.hasNextPage(); ++i) {
                    PDPage current = f.nextPage();
                    f.addLookupEntry(current, this.importPage(current));
                }
            });
            if (++var4_8 <= maxSteps) continue;
            throw new RuntimeException("Too many loops, currentStep: " + (int)var4_8 + ", maxSteps: " + maxSteps);
        }
        this.mixFragments.stream().forEach(PdfMixFragment::saintizeAnnotations);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.mixFragments.stream().forEach(IOUtils::closeQuietly);
        this.mixFragments.clear();
    }
}

