/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import org.sejda.commons.util.IOUtils;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.SamboxOutlineLevelsHandler;
import org.sejda.impl.sambox.component.optimization.OptimizationRuler;
import org.sejda.impl.sambox.component.split.PageDestinationsLevelPdfSplitter;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.outline.OutlinePageDestinations;
import org.sejda.model.parameter.SplitByOutlineLevelParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitByOutlineLevelTask
extends BaseTask<SplitByOutlineLevelParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(SplitByOutlineLevelTask.class);
    private int totalSteps;
    private PDDocument document = null;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PageDestinationsLevelPdfSplitter splitter;

    public void before(SplitByOutlineLevelParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
    }

    public void execute(SplitByOutlineLevelParameters parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource source : parameters.getSourceList()) {
            ++currentStep;
            LOG.debug("Opening {} ", (Object)source);
            this.document = ((PDDocumentHandler)source.open(this.documentLoader)).getUnderlyingPDDocument();
            LOG.debug("Retrieving outline information for level {}", (Object)parameters.getLevelToSplitAt());
            OutlinePageDestinations pagesDestination = new SamboxOutlineLevelsHandler(this.document, parameters.getMatchingTitleRegEx()).getPageDestinationsForLevel(parameters.getLevelToSplitAt());
            this.splitter = new PageDestinationsLevelPdfSplitter(this.document, parameters, pagesDestination, (boolean)new OptimizationRuler(parameters.getOptimizationPolicy()).apply(this.document));
            LOG.debug("Starting split by outline level for {} ", (Object)parameters);
            this.splitter.split(this.executionContext(), parameters.getOutputPrefix(), source);
            IOUtils.closeQuietly((Closeable)this.document);
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        LOG.debug("Input documents splitted and written to {}", (Object)parameters.getOutput());
    }

    public void after() {
        IOUtils.closeQuietly((Closeable)this.document);
        this.splitter = null;
    }
}

