/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.SetMetadataParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDDocumentCatalog;
import org.sejda.sambox.pdmodel.PDDocumentInformation;
import org.sejda.sambox.pdmodel.common.PDMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class SetMetadataTask
extends BaseTask<SetMetadataParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(SetMetadataTask.class);
    private PDDocumentHandler documentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    public void before(SetMetadataParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final SetMetadataParameters parameters) throws TaskException {
        int totalSteps = parameters.getSourceList().size();
        for (int sourceIndex = 0; sourceIndex < parameters.getSourceList().size(); ++sourceIndex) {
            PdfSource source = (PdfSource)parameters.getSourceList().get(sourceIndex);
            int fileNumber = this.executionContext().incrementAndGetOutputDocumentsCounter();
            try {
                LOG.debug("Opening {}", (Object)source);
                this.documentHandler = (PDDocumentHandler)source.open(this.documentLoader);
                this.documentHandler.setUpdateProducerModifiedDate(parameters.isUpdateProducerModifiedDate());
                if (parameters.isUpdateProducerModifiedDate().booleanValue()) {
                    this.documentHandler.setCreatorOnPDDocument();
                }
                File tmpFile = IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
                PDDocument doc = this.documentHandler.getUnderlyingPDDocument();
                doc.setOnBeforeWriteAction(new PDDocument.OnBeforeWrite(){

                    public void onBeforeWrite() throws IOException {
                        LOG.debug("Setting metadata on temporary document.");
                        PDDocumentInformation actualMeta = SetMetadataTask.this.documentHandler.getUnderlyingPDDocument().getDocumentInformation();
                        for (Map.Entry meta : parameters.getMetadata().entrySet()) {
                            LOG.trace("'{}' -> '{}'", meta.getKey(), meta.getValue());
                            actualMeta.setCustomMetadataValue((String)meta.getKey(), (String)meta.getValue());
                        }
                        for (String keyToRemove : parameters.getToRemove()) {
                            LOG.trace("Removing '{}'", (Object)keyToRemove);
                            actualMeta.removeMetadataField(keyToRemove);
                        }
                        PDDocumentCatalog catalog = SetMetadataTask.this.documentHandler.getUnderlyingPDDocument().getDocumentCatalog();
                        if (catalog.getMetadata() != null) {
                            LOG.debug("Document has XMP metadata stream");
                            SetMetadataTask.this.updateXmpMetadata(catalog, actualMeta);
                        }
                    }
                });
                this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
                this.documentHandler.setCompress(parameters.isCompress());
                this.documentHandler.savePDDocument(tmpFile, parameters.getOutput().getEncryptionAtRestPolicy());
                String outName = Optional.ofNullable(parameters.getSpecificResultFilename(fileNumber)).orElseGet(() -> NameGenerator.nameGenerator((String)parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(fileNumber)));
                this.outputWriter.addOutput(FileOutput.file((File)tmpFile).name(outName));
            }
            finally {
                org.sejda.commons.util.IOUtils.closeQuietly((Closeable)this.documentHandler);
            }
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(fileNumber).outOf(totalSteps);
        }
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Metadata set and written to {}", (Object)parameters.getOutput());
    }

    private XPathFactory newXPathFactory() {
        try {
            XPathFactory f = XPathFactory.newInstance();
            f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return f;
        }
        catch (XPathFactoryConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void setDate(String path, Document document, Calendar calendar) throws XPathExpressionException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        XPath xPath = this.newXPathFactory().newXPath();
        Node node = (Node)xPath.compile(path).evaluate(document, XPathConstants.NODE);
        if (node != null) {
            String value = "";
            if (calendar != null) {
                value = dateFormat.format(calendar.getTime());
            }
            node.setTextContent(value);
        }
    }

    private void setText(String path, Document document, String value) throws XPathExpressionException {
        XPath xPath = this.newXPathFactory().newXPath();
        Node node = (Node)xPath.compile(path).evaluate(document, XPathConstants.NODE);
        if (node != null) {
            if (value == null) {
                value = "";
            }
            node.setTextContent(value);
        }
    }

    private void updateXmpMetadata(PDDocumentCatalog catalog, PDDocumentInformation metadata) {
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            f.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            f.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            f.setFeature("http://xml.org/sax/features/external-general-entities", false);
            f.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            f.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            f.setXIncludeAware(false);
            f.setExpandEntityReferences(false);
            DocumentBuilder b = f.newDocumentBuilder();
            Document document = b.parse(catalog.getMetadata().createInputStream());
            this.setDate("//*[name()='xmp:CreateDate']", document, metadata.getCreationDate());
            this.setDate("//*[name()='xmp:ModifyDate']", document, metadata.getModificationDate());
            this.setText("//*[name()='pdf:Producer']", document, metadata.getProducer());
            this.setText("//*[name()='xmp:CreatorTool']", document, metadata.getCreator());
            this.setText("//*[name()='pdf:Keywords']", document, metadata.getKeywords());
            Calendar nowCalendar = Calendar.getInstance();
            nowCalendar.setTime(new Date());
            this.setDate("//*[name()='xmp:MetadataDate']", document, nowCalendar);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter writer = new StringWriter();
            DOMSource domSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(domSource, streamResult);
            String updatedXml = writer.getBuffer().toString();
            catalog.setMetadata(new PDMetadata((InputStream)new ByteArrayInputStream(updatedXml.getBytes(StandardCharsets.UTF_8))));
        }
        catch (SAXParseException ex) {
            LOG.warn("Failed to parse XMP metadata, skipping update", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to update XMP metadata", ex);
        }
    }

    public void after() {
        org.sejda.commons.util.IOUtils.closeQuietly((Closeable)this.documentHandler);
    }
}

