/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import org.sejda.commons.util.IOUtils;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.SamboxOutlineLevelsHandler;
import org.sejda.impl.sambox.component.split.PageDestinationsLevelPdfExtractor;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.outline.OutlineExtractPageDestinations;
import org.sejda.model.parameter.ExtractByOutlineParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractByOutlineTask
extends BaseTask<ExtractByOutlineParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractByOutlineTask.class);
    private PDDocument document = null;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    public void before(ExtractByOutlineParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.documentLoader = new DefaultPdfSourceOpener();
    }

    public void execute(ExtractByOutlineParameters parameters) throws TaskException {
        for (PdfSource source : parameters.getSourceList()) {
            LOG.debug("Opening {} ", (Object)source);
            this.document = ((PDDocumentHandler)source.open(this.documentLoader)).getUnderlyingPDDocument();
            LOG.debug("Retrieving outline information for level {} and match regex {}", (Object)parameters.getLevel(), (Object)parameters.getMatchingTitleRegEx());
            OutlineExtractPageDestinations pagesDestination = new SamboxOutlineLevelsHandler(this.document, parameters.getMatchingTitleRegEx()).getExtractPageDestinations(parameters.getLevel(), parameters.isIncludePageAfter());
            LOG.debug("Starting extraction by outline, level {} and match regex {}", (Object)parameters.getLevel(), (Object)parameters.getMatchingTitleRegEx());
            new PageDestinationsLevelPdfExtractor(this.document, parameters, pagesDestination, source).extract(this.executionContext());
            IOUtils.closeQuietly((Closeable)this.document);
        }
        LOG.debug("Extraction completed and outputs written to {}", (Object)parameters.getOutput());
    }

    public void after() {
        IOUtils.closeQuietly((Closeable)this.document);
    }
}

