/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.injector;

import java.lang.annotation.Annotation;
import javax.inject.Named;

public class Key<T> {
    final Class<T> type;
    final Class<? extends Annotation> qualifier;
    final String name;

    private Key(Class<T> type, Class<? extends Annotation> qualifier, String name) {
        this.type = type;
        this.qualifier = qualifier;
        this.name = name;
    }

    public static <T> Key<T> of(Class<T> type) {
        return new Key<T>(type, null, null);
    }

    public static <T> Key<T> of(Class<T> type, Class<? extends Annotation> qualifier) {
        return new Key<T>(type, qualifier, null);
    }

    public static <T> Key<T> of(Class<T> type, String name) {
        return new Key<T>(type, Named.class, name);
    }

    static <T> Key<T> of(Class<T> type, Annotation qualifier) {
        if (qualifier == null) {
            return Key.of(type);
        }
        return qualifier.annotationType().equals(Named.class) ? Key.of(type, ((Named)qualifier).value()) : Key.of(type, qualifier.annotationType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        if (!this.type.equals(key.type)) {
            return false;
        }
        if (this.qualifier != null ? !this.qualifier.equals(key.qualifier) : key.qualifier != null) {
            return false;
        }
        return !(this.name == null ? key.name != null : !this.name.equals(key.name));
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        String suffix = this.name != null ? "@\"" + this.name + "\"" : (this.qualifier != null ? "@" + this.qualifier.getSimpleName() : "");
        return this.type.getName() + suffix;
    }
}

