/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.basic;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.pdfsam.ConfigurableProperty;
import org.pdfsam.Pdfsam;
import org.sejda.commons.util.RequireUtils;

public class PdfsamBasic
implements Pdfsam {
    private Properties properties = new Properties();
    private String name;
    private String shortName;

    public PdfsamBasic(String name, String shortName) throws IOException {
        RequireUtils.requireNotBlank((String)name, (String)"Application name cannot be blank");
        RequireUtils.requireNotBlank((String)shortName, (String)"Application short name cannot be blank");
        this.name = name;
        this.shortName = shortName;
        try (InputStream stream = this.getClass().getResourceAsStream("/pdfsam.properties");){
            this.properties.load(stream);
        }
    }

    public String name() {
        return this.name;
    }

    public String shortName() {
        return this.shortName;
    }

    public String property(ConfigurableProperty prop, String defaultValue) {
        return this.properties.getProperty(prop.prop, defaultValue);
    }

    public String property(ConfigurableProperty prop) {
        return this.properties.getProperty(prop.prop, "");
    }
}

