/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.i18n;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.i18n.SetLocaleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class DefaultI18nContext
implements I18nContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultI18nContext.class);
    private final Set<Locale> supportedLocales = Set.of(new Locale("af"), new Locale("eu"), new Locale("bs"), new Locale("pt", "BR"), Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE, new Locale("co"), new Locale("hr"), new Locale("cs"), new Locale("da"), new Locale("nl"), Locale.UK, Locale.FRENCH, Locale.GERMAN, new Locale("he"), new Locale("hu"), new Locale("el"), Locale.JAPANESE, Locale.ITALIAN, new Locale("pl"), new Locale("pt"), new Locale("ro"), new Locale("ru"), new Locale("sk"), new Locale("sl"), new Locale("sr"), new Locale("sv"), new Locale("es"), new Locale("tr"), new Locale("uk"), new Locale("fi"), new Locale("ko"));
    private I18n i18n;

    DefaultI18nContext() {
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    private void refreshBundles() {
        LOG.trace("Loading i18n bundle for {}", (Object)Locale.getDefault());
        this.i18n = I18nFactory.getI18n(DefaultI18nContext.class);
        LOG.debug("Locale set to {}", (Object)Locale.getDefault().getDisplayLanguage());
    }

    @EventListener
    public void refresh(SetLocaleEvent e) {
        String localeString = e.getLocaleString();
        if (StringUtils.isNotBlank((CharSequence)localeString)) {
            LOG.trace("Setting default locale to {}", (Object)localeString);
            Optional.ofNullable(Locale.forLanguageTag(localeString)).filter(this.supportedLocales::contains).ifPresent(Locale::setDefault);
            this.refreshBundles();
        }
    }

    Locale getBestLocale() {
        if (this.supportedLocales.contains(Locale.getDefault())) {
            LOG.trace("Using best matching locale: {}", (Object)Locale.getDefault());
            return Locale.getDefault();
        }
        Locale onlyLanguage = new Locale(Locale.getDefault().getLanguage());
        if (this.supportedLocales.contains(onlyLanguage)) {
            LOG.trace("Using supported locale closest to default {}", (Object)onlyLanguage);
            return onlyLanguage;
        }
        LOG.trace("Using fallback locale");
        return Locale.UK;
    }

    public static I18nContext getInstance() {
        return DefaultI18nContextHolder.CONTEXT;
    }

    @Override
    public String i18n(String input) {
        this.initBundleIfRequired();
        return this.i18n.tr(input);
    }

    @Override
    public String i18n(String input, String value) {
        this.initBundleIfRequired();
        return this.i18n.tr(input, (Object)value);
    }

    @Override
    public String i18n(String input, String value0, String value1) {
        this.initBundleIfRequired();
        return this.i18n.tr(input, (Object)value0, (Object)value1);
    }

    void initBundleIfRequired() {
        if (Objects.isNull(this.i18n)) {
            Locale.setDefault(this.getBestLocale());
            this.refreshBundles();
        }
    }

    @Override
    public Set<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    private static final class DefaultI18nContextHolder {
        static final DefaultI18nContext CONTEXT = new DefaultI18nContext();

        private DefaultI18nContextHolder() {
        }
    }
}

