/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.core.support.io.IOUtils;
import org.sejda.model.output.SingleOrMultipleTaskOutput;
import org.sejda.model.parameter.base.MultiplePdfSourceParameters;
import org.sejda.model.parameter.base.SingleOrMultipleOutputTaskParameters;

public class MultiplePdfSourceMultipleOutputParameters
extends MultiplePdfSourceParameters
implements SingleOrMultipleOutputTaskParameters {
    private String outputPrefix = "";
    @Valid
    @NotNull
    private SingleOrMultipleTaskOutput output;
    private final List<String> specificResultFilenames = new ArrayList<String>();

    @Override
    public String getOutputPrefix() {
        return this.outputPrefix;
    }

    @Override
    public void setOutputPrefix(String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    @Override
    public SingleOrMultipleTaskOutput getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(SingleOrMultipleTaskOutput output) {
        this.output = output;
    }

    public void addSpecificResultFilename(String filename) {
        this.specificResultFilenames.add(filename);
    }

    public void addSpecificResultFilenames(Collection<String> filenames) {
        this.specificResultFilenames.addAll(filenames);
    }

    public List<String> getSpecificResultFilenames() {
        return Collections.unmodifiableList(this.specificResultFilenames);
    }

    public String getSpecificResultFilename(int fileNumber) {
        return this.getSpecificResultFilename(fileNumber, ".pdf");
    }

    public String getSpecificResultFilename(int fileNumber, String expectedExtension) {
        if (this.specificResultFilenames.size() >= fileNumber) {
            return Optional.ofNullable(this.specificResultFilenames.get(fileNumber - 1)).filter(StringUtils::isNotBlank).map(IOUtils::toSafeFilename).map(n -> {
                String ext = StringUtils.defaultString((String)expectedExtension).toLowerCase();
                if (!n.toLowerCase().endsWith(ext)) {
                    return n + ext;
                }
                return n;
            }).orElse(null);
        }
        return null;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.outputPrefix).append((Object)this.output).append(this.specificResultFilenames).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MultiplePdfSourceMultipleOutputParameters)) {
            return false;
        }
        MultiplePdfSourceMultipleOutputParameters parameter = (MultiplePdfSourceMultipleOutputParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.outputPrefix, (Object)parameter.outputPrefix).append((Object)this.output, (Object)parameter.output).append(this.specificResultFilenames, parameter.specificResultFilenames).isEquals();
    }
}

