/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.input;

import java.io.IOException;
import java.io.InputStream;
import javax.validation.constraints.NotNull;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSources;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.AbstractSource;
import org.sejda.model.input.SourceDispatcher;

public class StreamSource
extends AbstractSource<InputStream> {
    @NotNull
    private final InputStream stream;

    private StreamSource(InputStream stream, String name) {
        super(name);
        this.stream = stream;
    }

    @Override
    public InputStream getSource() {
        return this.stream;
    }

    @Override
    public <R> R dispatch(SourceDispatcher<R> dispatcher) throws TaskIOException {
        return dispatcher.dispatch(this);
    }

    @Override
    public SeekableSource initializeSeekableSource() throws IOException {
        return SeekableSources.onTempFileSeekableSourceFrom((InputStream)this.getEncryptionAtRestPolicy().decrypt(this.stream), (String)this.getName());
    }

    public static StreamSource newInstance(InputStream stream, String name) {
        if (stream == null) {
            throw new IllegalArgumentException("A not null stream instance and a not blank name are expected.");
        }
        return new StreamSource(stream, name);
    }
}

