/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.input;

import java.io.IOException;
import java.io.InputStream;
import javax.validation.constraints.NotNull;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSources;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.AbstractPdfSource;
import org.sejda.model.input.PdfSourceOpener;

public final class PdfStreamSource
extends AbstractPdfSource<InputStream> {
    @NotNull
    private final InputStream stream;

    private PdfStreamSource(InputStream stream, String name, String password) {
        super(name, password);
        this.stream = stream;
    }

    @Override
    public InputStream getSource() {
        return this.stream;
    }

    @Override
    public <T> T open(PdfSourceOpener<T> opener) throws TaskIOException {
        return opener.open(this);
    }

    @Override
    public SeekableSource initializeSeekableSource() throws IOException {
        return SeekableSources.onTempFileSeekableSourceFrom((InputStream)this.getEncryptionAtRestPolicy().decrypt(this.stream), (String)this.getName());
    }

    public static PdfStreamSource newInstanceNoPassword(InputStream stream, String name) {
        return PdfStreamSource.newInstanceWithPassword(stream, name, null);
    }

    public static PdfStreamSource newInstanceWithPassword(InputStream stream, String name, String password) {
        if (stream == null) {
            throw new IllegalArgumentException("A not null stream instance and a not blank name are expected.");
        }
        return new PdfStreamSource(stream, name, password);
    }
}

