/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.input;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSources;
import org.sejda.model.encryption.NoEncryptionAtRest;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.AbstractSource;
import org.sejda.model.input.SourceDispatcher;
import org.sejda.model.validation.constraint.IsFile;

public class FileSource
extends AbstractSource<File> {
    @IsFile
    private final File file;

    public FileSource(File file) {
        super(file.getName());
        this.file = file;
    }

    @Override
    public File getSource() {
        return this.file;
    }

    @Override
    public String toString() {
        return this.file.getAbsolutePath();
    }

    @Override
    public <R> R dispatch(SourceDispatcher<R> dispatcher) throws TaskIOException {
        return dispatcher.dispatch(this);
    }

    @Override
    public SeekableSource initializeSeekableSource() throws IOException {
        if (this.getEncryptionAtRestPolicy() instanceof NoEncryptionAtRest) {
            return SeekableSources.seekableSourceFrom((File)this.file);
        }
        return SeekableSources.onTempFileSeekableSourceFrom((InputStream)this.getEncryptionAtRestPolicy().decrypt(new FileInputStream(this.file)), (String)this.file.getName());
    }

    public static FileSource newInstance(File file) {
        if (file == null || !file.isFile()) {
            throw new IllegalArgumentException("A not null File instance that isFile is expected. Path: " + file);
        }
        return new FileSource(file);
    }
}

