/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.encryption;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionHelpers {
    private static SecretKeySpec keyToSpec(String salt, String key) throws NoSuchAlgorithmException {
        byte[] keyBytes = (salt + key).getBytes(StandardCharsets.UTF_8);
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        keyBytes = sha.digest(keyBytes);
        keyBytes = Arrays.copyOf(keyBytes, 16);
        return new SecretKeySpec(keyBytes, "AES");
    }

    public static Cipher getCipher(String salt, String key, int mode) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(mode, EncryptionHelpers.keyToSpec(salt, key));
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

