/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.common;

public final class RomanNumbersUtils {
    private RomanNumbersUtils() {
    }

    public static String toRoman(long toConvert) {
        if (toConvert < 0L) {
            throw new IllegalArgumentException();
        }
        if (toConvert == 0L) {
            return "nulla";
        }
        long n = toConvert;
        StringBuilder buf = new StringBuilder();
        Numeral[] values = Numeral.values();
        for (int i = values.length - 1; i >= 0; --i) {
            while (n >= (long)values[i].weight) {
                buf.append((Object)values[i]);
                n -= (long)values[i].weight;
            }
        }
        return buf.toString();
    }

    private static enum Numeral {
        I(1),
        IV(4),
        V(5),
        IX(9),
        X(10),
        XL(40),
        L(50),
        XC(90),
        C(100),
        CD(400),
        D(500),
        CM(900),
        M(1000);

        private int weight;

        private Numeral(int weight) {
            this.weight = weight;
        }
    }
}

