/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.rotate;

import java.util.Objects;
import java.util.Set;
import org.pdfsam.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.support.params.MultipleOutputTaskParametersBuilder;
import org.pdfsam.task.BulkRotateParameters;
import org.pdfsam.task.PdfRotationInput;
import org.sejda.commons.collection.NullSafeSet;
import org.sejda.model.input.PdfSource;
import org.sejda.model.output.SingleOrMultipleTaskOutput;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PagesSelection;
import org.sejda.model.pdf.page.PredefinedSetOfPages;
import org.sejda.model.rotation.Rotation;

class RotateParametersBuilder
extends AbstractPdfOutputParametersBuilder<BulkRotateParameters>
implements MultipleOutputTaskParametersBuilder<BulkRotateParameters> {
    private SingleOrMultipleTaskOutput output;
    private String prefix;
    private Set<PdfRotationInput> inputs = new NullSafeSet();
    private Rotation rotation;
    private PredefinedSetOfPages predefinedRotationType;

    RotateParametersBuilder() {
    }

    void addInput(PdfSource<?> source, Set<PageRange> pageSelection) {
        if (Objects.isNull(pageSelection) || pageSelection.isEmpty()) {
            this.inputs.add(new PdfRotationInput(source, this.rotation, new PagesSelection[]{this.predefinedRotationType}));
        } else {
            this.inputs.add(new PdfRotationInput(source, this.rotation, (PagesSelection[])pageSelection.stream().toArray(PageRange[]::new)));
        }
    }

    boolean hasInput() {
        return !this.inputs.isEmpty();
    }

    public void output(SingleOrMultipleTaskOutput output) {
        this.output = output;
    }

    public void prefix(String prefix) {
        this.prefix = prefix;
    }

    protected SingleOrMultipleTaskOutput getOutput() {
        return this.output;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void rotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public void rotationType(PredefinedSetOfPages predefinedRotationType) {
        this.predefinedRotationType = predefinedRotationType;
    }

    public BulkRotateParameters build() {
        BulkRotateParameters params = new BulkRotateParameters();
        params.setCompress(this.isCompress());
        params.setExistingOutputPolicy(this.existingOutput());
        params.setVersion(this.getVersion());
        params.setOutput(this.getOutput());
        params.setOutputPrefix(this.getPrefix());
        this.inputs.forEach(arg_0 -> ((BulkRotateParameters)params).addInput(arg_0));
        return params;
    }
}

