/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.Map;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.ui.WorkspaceService;
import org.sejda.commons.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonWorkspaceService
implements WorkspaceService {
    private static final Logger LOG = LoggerFactory.getLogger(JsonWorkspaceService.class);
    private JSON jackson = new JSON().without(new JSON.Feature[]{JSON.Feature.USE_FIELDS}).with(new JSON.Feature[]{JSON.Feature.PRETTY_PRINT_OUTPUT}).without(new JSON.Feature[]{JSON.Feature.WRITE_NULL_PROPERTIES});

    JsonWorkspaceService() {
    }

    @Override
    public void saveWorkspace(Map<String, Map<String, String>> data, File destination) {
        RequireUtils.requireNotNullArg((Object)destination, (String)"Destination file cannot be null");
        LOG.debug(DefaultI18nContext.getInstance().i18n("Saving workspace data to {0}", destination.getAbsolutePath()));
        try {
            this.jackson.write(data, destination);
            LOG.info(DefaultI18nContext.getInstance().i18n("Workspace saved"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Map<String, String>> loadWorkspace(File workspace) {
        RequireUtils.requireNotNullArg((Object)workspace, (String)"Workspace file cannot be null");
        Map data = Collections.emptyMap();
        try (FileInputStream stream = new FileInputStream(workspace);){
            data = this.jackson.mapFrom((Object)stream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return data;
    }
}

