/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.pdf;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class PdfListParser
implements Function<Path, List<File>> {
    PdfListParser() {
    }

    @Override
    public List<File> apply(Path listFile) {
        if (Objects.isNull(listFile)) {
            return Collections.emptyList();
        }
        try {
            return Files.lines(listFile).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(s -> {
                String[] items = s.split(",");
                if (items.length > 0) {
                    return items[0];
                }
                return "";
            }).map(String::trim).filter(s -> s.toUpperCase().endsWith("PDF")).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(Predicate.not(x$0 -> Files.isDirectory(x$0, new LinkOption[0]))).map(Path::toFile).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

