/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.news;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.news.FetchLatestNewsRequest;
import org.pdfsam.news.LatestNewsEvent;
import org.pdfsam.news.NewImportantNewsEvent;
import org.pdfsam.news.NewsData;
import org.pdfsam.news.NewsService;
import org.pdfsam.news.ShowNewsPanelRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class LatestNewsController {
    private static final Logger LOG = LoggerFactory.getLogger(LatestNewsController.class);
    private NewsService service;
    private int currentLatest = -1;

    @Inject
    LatestNewsController(NewsService service) {
        this.service = service;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void fetchLatestNews(FetchLatestNewsRequest event) {
        LOG.debug(DefaultI18nContext.getInstance().i18n("Fetching latest news"));
        ((CompletableFuture)CompletableFuture.supplyAsync(this.service::getLatestNews).thenAcceptAsync(news -> {
            if (Objects.nonNull(news) && !news.isEmpty()) {
                this.currentLatest = ((NewsData)news.get(0)).getId();
                StaticStudio.eventStudio().broadcast((Object)new LatestNewsEvent(news, this.service.getLatestNewsSeen() >= this.currentLatest));
                news.stream().filter(n -> n.isImportant()).findFirst().filter(n -> this.service.getLatestImportantNewsSeen() < n.getId()).ifPresent(n -> {
                    this.service.setLatestImportantNewsSeen(n.getId());
                    StaticStudio.eventStudio().broadcast((Object)new NewImportantNewsEvent(n));
                });
            }
        })).whenComplete((r, e) -> {
            if (Objects.nonNull(e)) {
                LOG.warn(DefaultI18nContext.getInstance().i18n("Unable to retrieve the latest news"), e);
            }
        });
    }

    @EventListener
    public void onShowNewsPanel(ShowNewsPanelRequest req) {
        if (this.service.getLatestNewsSeen() < this.currentLatest) {
            this.service.setLatestNewsSeen(this.currentLatest);
        }
    }
}

