/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.support.validation;

import org.pdfsam.support.validation.PositiveIntegerStringValidator;
import org.sejda.commons.util.RequireUtils;

class PositiveIntRangeStringValidator
extends PositiveIntegerStringValidator {
    private int upper = Integer.MAX_VALUE;
    private int lower = Integer.MIN_VALUE;

    public PositiveIntRangeStringValidator(int lower, int upper) {
        RequireUtils.requireArg((lower > 0 && upper > 0 ? 1 : 0) != 0, (String)("Lower and upper limit cannot be negative numbers, lower=" + lower + " upper=" + upper));
        this.upper = upper;
        this.lower = lower;
    }

    @Override
    public boolean isValid(String input) {
        if (super.isValid(input)) {
            int victim = Integer.parseInt(input);
            return victim >= this.lower && victim <= this.upper;
        }
        return false;
    }
}

