/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.support;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.pdfsam.support.KeyValueItem;
import org.sejda.commons.util.RequireUtils;

public class LocaleKeyValueItem
implements KeyValueItem<String, String>,
Comparable<LocaleKeyValueItem> {
    private Locale locale;

    public LocaleKeyValueItem(Locale locale) {
        RequireUtils.requireNotNullArg((Object)locale, (String)"Locale cannot be null");
        this.locale = locale;
    }

    @Override
    public String getKey() {
        return this.locale.toLanguageTag();
    }

    @Override
    public String getValue() {
        return StringUtils.capitalize((String)this.locale.getDisplayName());
    }

    public String toString() {
        return this.getValue();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getKey()).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocaleKeyValueItem)) {
            return false;
        }
        LocaleKeyValueItem item = (LocaleKeyValueItem)other;
        return new EqualsBuilder().append((Object)this.getKey(), (Object)item.getKey()).isEquals();
    }

    @Override
    public int compareTo(LocaleKeyValueItem o) {
        RequireUtils.requireNotNullArg((Object)o, (String)"Could not compare null elements");
        return this.getValue().compareTo(o.getValue());
    }
}

