/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.pdf;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.pdfsam.module.ModuleOwned;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.sejda.commons.util.RequireUtils;

public class PdfLoadRequestEvent
implements ModuleOwned {
    private Collection<PdfDocumentDescriptor> documents = new ConcurrentLinkedQueue<PdfDocumentDescriptor>();
    private String ownerModule = "";

    public PdfLoadRequestEvent(String ownerModule) {
        RequireUtils.requireNotBlank((String)ownerModule, (String)"Owner module cannot be blank");
        this.ownerModule = ownerModule;
    }

    @Override
    public String getOwnerModule() {
        return this.ownerModule;
    }

    public boolean add(PdfDocumentDescriptor e) {
        return this.documents.add(e);
    }

    public boolean addAll(Collection<PdfDocumentDescriptor> c) {
        return this.documents.addAll(c);
    }

    public Collection<PdfDocumentDescriptor> getDocuments() {
        return Collections.unmodifiableCollection(this.documents);
    }
}

