/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.pdf;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;

public enum PdfDescriptorLoadingStatus {
    INITIAL,
    REQUESTED(FontAwesomeIcon.CLOCK_ALT, ""),
    LOADING(FontAwesomeIcon.ANGLE_RIGHT, ""),
    LOADED,
    LOADED_WITH_USER_PWD_DECRYPTION(FontAwesomeIcon.UNLOCK, DefaultI18nContext.getInstance().i18n("Valid user password provided.")),
    ENCRYPTED(FontAwesomeIcon.LOCK, DefaultI18nContext.getInstance().i18n("This document is encrypted, click to provide a password."), "with-warnings"),
    WITH_ERRORS(FontAwesomeIcon.WARNING, DefaultI18nContext.getInstance().i18n("An error has occurred, click for more details."), "with-errors");

    private Set<PdfDescriptorLoadingStatus> validNext = new HashSet<PdfDescriptorLoadingStatus>();
    private FontAwesomeIcon icon;
    private String description;
    private String style;

    private PdfDescriptorLoadingStatus() {
        this(null, "");
    }

    private PdfDescriptorLoadingStatus(FontAwesomeIcon icon, String description) {
        this(icon, description, "");
    }

    private PdfDescriptorLoadingStatus(FontAwesomeIcon icon, String description, String style) {
        this.icon = icon;
        this.description = StringUtils.defaultString((String)description);
        this.style = StringUtils.defaultString((String)style);
    }

    public FontAwesomeIcon getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStyle() {
        return this.style;
    }

    private void setValidDestinationStatus(PdfDescriptorLoadingStatus ... canMoveTo) {
        Arrays.stream(canMoveTo).forEach(this.validNext::add);
    }

    public boolean canMoveTo(PdfDescriptorLoadingStatus dest) {
        return this.validNext.contains((Object)dest);
    }

    public PdfDescriptorLoadingStatus moveTo(PdfDescriptorLoadingStatus dest) {
        if (this.canMoveTo(dest)) {
            return dest;
        }
        throw new IllegalStateException("Cannot move status from " + this + " to " + dest);
    }

    public boolean isFinal() {
        return this.validNext.isEmpty();
    }

    static {
        INITIAL.setValidDestinationStatus(REQUESTED, WITH_ERRORS);
        ENCRYPTED.setValidDestinationStatus(REQUESTED, WITH_ERRORS);
        LOADING.setValidDestinationStatus(LOADED, LOADED_WITH_USER_PWD_DECRYPTION, ENCRYPTED, WITH_ERRORS);
        REQUESTED.setValidDestinationStatus(LOADING, WITH_ERRORS);
    }
}

