/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.filter.DecodeResult;
import org.sejda.sambox.filter.Filter;
import org.sejda.sambox.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ASCIIHexFilter
extends Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ASCIIHexFilter.class);
    private static final int[] REVERSE_HEX = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    ASCIIHexFilter() {
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        try {
            int firstByte;
            while ((firstByte = encoded.read()) != -1) {
                while (this.isWhitespace(firstByte)) {
                    firstByte = encoded.read();
                }
                if (firstByte == -1 || this.isEOD(firstByte)) break;
                if (REVERSE_HEX[firstByte] == -1) {
                    LOG.error("Invalid hex, int: " + firstByte + " char: " + (char)firstByte);
                }
                int value = REVERSE_HEX[firstByte] * 16;
                int secondByte = encoded.read();
                if (secondByte == -1 || this.isEOD(secondByte)) {
                    decoded.write(value);
                    break;
                }
                if (secondByte >= 0) {
                    if (REVERSE_HEX[secondByte] == -1) {
                        LOG.error("Invalid hex, int: " + secondByte + " char: " + (char)secondByte);
                    }
                    value += REVERSE_HEX[secondByte];
                }
                decoded.write(value);
            }
            decoded.flush();
            return new DecodeResult(parameters);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Illegal character in ASCIIHexFilter", e);
        }
    }

    private boolean isWhitespace(int c) {
        return c == 0 || c == 9 || c == 10 || c == 12 || c == 13 || c == 32;
    }

    private boolean isEOD(int c) {
        return c == 62;
    }

    @Override
    public void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        int byteRead;
        while ((byteRead = input.read()) != -1) {
            encoded.write(Hex.getBytes((byte)byteRead));
        }
        encoded.flush();
    }
}

