/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sejda.sambox.contentstream.PDFStreamEngine;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.contentstream.operator.OperatorProcessor;
import org.sejda.sambox.contentstream.operator.state.Concatenate;
import org.sejda.sambox.contentstream.operator.state.Restore;
import org.sejda.sambox.contentstream.operator.state.Save;
import org.sejda.sambox.contentstream.operator.state.SetGraphicsStateParameters;
import org.sejda.sambox.contentstream.operator.state.SetMatrix;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.sejda.sambox.util.Matrix;

public class ImageLocationsExtractor
extends PDFStreamEngine {
    private Map<PDPage, List<Rectangle>> imageLocations = new HashMap<PDPage, List<Rectangle>>();

    public ImageLocationsExtractor() {
        this.addOperator((OperatorProcessor)new Concatenate());
        this.addOperator((OperatorProcessor)new SetGraphicsStateParameters());
        this.addOperator((OperatorProcessor)new Save());
        this.addOperator((OperatorProcessor)new Restore());
        this.addOperator((OperatorProcessor)new SetMatrix());
        this.addOperator(new XObjectOperator());
    }

    public void process(PDDocument document) throws IOException {
        this.imageLocations.clear();
        for (PDPage page : document.getPages()) {
            this.processPage(page);
        }
    }

    public Map<PDPage, List<Rectangle>> getImageLocations() {
        return this.imageLocations;
    }

    private class XObjectOperator
    extends OperatorProcessor {
        private XObjectOperator() {
        }

        public void process(Operator operator, List<COSBase> operands) throws IOException {
            COSName objectName = (COSName)operands.get(0);
            PDXObject xobject = ImageLocationsExtractor.this.getResources().getXObject(objectName);
            if (xobject instanceof PDImageXObject) {
                Matrix ctmNew = ImageLocationsExtractor.this.getGraphicsState().getCurrentTransformationMatrix();
                float imageXScale = ctmNew.getScalingFactorX();
                float imageYScale = ctmNew.getScalingFactorY();
                if (!ImageLocationsExtractor.this.imageLocations.containsKey(ImageLocationsExtractor.this.getCurrentPage())) {
                    ImageLocationsExtractor.this.imageLocations.put(ImageLocationsExtractor.this.getCurrentPage(), new ArrayList());
                }
                ((List)ImageLocationsExtractor.this.imageLocations.get(ImageLocationsExtractor.this.getCurrentPage())).add(new Rectangle((int)ctmNew.getTranslateX(), (int)ctmNew.getTranslateY(), (int)imageXScale, (int)imageYScale));
            } else if (xobject instanceof PDFormXObject) {
                PDFormXObject form = (PDFormXObject)xobject;
                ImageLocationsExtractor.this.showForm(form);
            }
        }

        public String getName() {
            return "Do";
        }
    }
}

