/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.sejda.common.LookupTable;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.impl.sambox.util.AcroFormUtils;
import org.sejda.impl.sambox.util.FontUtils;
import org.sejda.model.pdf.form.AcroFormPolicy;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.common.PDDictionaryWrapper;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.form.PDField;
import org.sejda.sambox.pdmodel.interactive.form.PDFieldFactory;
import org.sejda.sambox.pdmodel.interactive.form.PDNonTerminalField;
import org.sejda.sambox.pdmodel.interactive.form.PDTerminalField;
import org.sejda.sambox.pdmodel.interactive.form.PDVariableText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcroFormsMerger {
    private static final Logger LOG = LoggerFactory.getLogger(AcroFormsMerger.class);
    private static final COSName[] FIELD_KEYS = new COSName[]{COSName.FT, COSName.PARENT, COSName.KIDS, COSName.T, COSName.TU, COSName.TM, COSName.FF, COSName.V, COSName.DV, COSName.Q, COSName.DS, COSName.RV, COSName.OPT, COSName.MAX_LEN, COSName.TI, COSName.I, COSName.LOCK, COSName.SV, COSName.DATAPREP};
    private static final COSName[] WIDGET_KEYS = new COSName[]{COSName.TYPE, COSName.SUBTYPE, COSName.RECT, COSName.CONTENTS, COSName.P, COSName.NM, COSName.M, COSName.F, COSName.AP, COSName.AS, COSName.BORDER, COSName.C, COSName.STRUCT_PARENT, COSName.OC, COSName.AF, COSName.CA, COSName.CA_NS, COSName.LANG, COSName.BM, COSName.H, COSName.MK, COSName.A, COSName.BS, COSName.PMD};
    private AcroFormPolicy policy;
    private PDAcroForm form;
    private String random = Long.toString(UUID.randomUUID().getMostSignificantBits(), 36);
    private Long counter = 0L;
    private final BiFunction<PDTerminalField, LookupTable<PDField>, PDTerminalField> createOrReuseTerminalField = (existing, fieldsLookup) -> {
        PDField previouslyCreated = Optional.ofNullable(this.getMergedField(existing.getFullyQualifiedName())).orElseGet(() -> (PDField)fieldsLookup.lookup(existing));
        if (Objects.isNull(previouslyCreated)) {
            previouslyCreated = PDFieldFactory.createFieldAddingChildToParent((PDAcroForm)this.form, (COSDictionary)existing.getCOSObject().duplicate(), (PDNonTerminalField)((PDNonTerminalField)fieldsLookup.lookup((Object)existing.getParent())));
            previouslyCreated.getCOSObject().removeItem(COSName.KIDS);
            fieldsLookup.addLookupEntry(existing, (Object)previouslyCreated);
        }
        if (!previouslyCreated.isTerminal()) {
            LOG.warn("Cannot merge terminal field because a non terminal field with the same name already exists: {}", (Object)existing.getFullyQualifiedName());
            return null;
        }
        return (PDTerminalField)previouslyCreated;
    };
    private final BiFunction<PDTerminalField, LookupTable<PDField>, PDTerminalField> createRenamingTerminalField = (existing, fieldsLookup) -> {
        PDTerminalField newField = (PDTerminalField)PDFieldFactory.createFieldAddingChildToParent((PDAcroForm)this.form, (COSDictionary)existing.getCOSObject().duplicate(), (PDNonTerminalField)((PDNonTerminalField)fieldsLookup.lookup((Object)existing.getParent())));
        if (Objects.nonNull(this.getMergedField(existing.getFullyQualifiedName())) || fieldsLookup.hasLookupFor(existing)) {
            Object[] objectArray = new Object[3];
            objectArray[0] = existing.getPartialName();
            objectArray[1] = this.random;
            this.counter = this.counter + 1L;
            objectArray[2] = this.counter;
            newField.setPartialName(String.format("%s%s%d", objectArray));
            LOG.info("Existing terminal field renamed from {} to {}", (Object)existing.getPartialName(), (Object)newField.getPartialName());
        }
        newField.getCOSObject().removeItem(COSName.KIDS);
        fieldsLookup.addLookupEntry(existing, (Object)newField);
        return newField;
    };
    private final BiConsumer<PDField, LookupTable<PDField>> createOrReuseNonTerminalField = (field, fieldsLookup) -> {
        if (this.getMergedField(field.getFullyQualifiedName()) == null && !fieldsLookup.hasLookupFor(field)) {
            PDField newField = PDFieldFactory.createFieldAddingChildToParent((PDAcroForm)this.form, (COSDictionary)field.getCOSObject().duplicate(), (PDNonTerminalField)((PDNonTerminalField)fieldsLookup.lookup((Object)field.getParent())));
            newField.getCOSObject().removeItem(COSName.KIDS);
            fieldsLookup.addLookupEntry(field, (Object)newField);
        }
    };
    private final BiConsumer<PDField, LookupTable<PDField>> createRenamingNonTerminalField = (field, fieldsLookup) -> {
        PDField newField = PDFieldFactory.createFieldAddingChildToParent((PDAcroForm)this.form, (COSDictionary)field.getCOSObject().duplicate(), (PDNonTerminalField)((PDNonTerminalField)fieldsLookup.lookup((Object)field.getParent())));
        if (this.getMergedField(field.getFullyQualifiedName()) != null || fieldsLookup.hasLookupFor(field)) {
            Object[] objectArray = new Object[3];
            objectArray[0] = field.getPartialName();
            objectArray[1] = this.random;
            this.counter = this.counter + 1L;
            objectArray[2] = this.counter;
            newField.setPartialName(String.format("%s%s%d", objectArray));
            LOG.info("Existing non terminal field renamed from {} to {}", (Object)field.getPartialName(), (Object)newField.getPartialName());
        }
        newField.getCOSObject().removeItem(COSName.KIDS);
        fieldsLookup.addLookupEntry(field, (Object)newField);
    };

    private PDField getMergedField(String fullyQualifiedName) {
        return Optional.ofNullable(fullyQualifiedName).map(arg_0 -> ((PDAcroForm)this.form).getField(arg_0)).orElse(null);
    }

    public AcroFormsMerger(AcroFormPolicy policy, PDDocument destination) {
        this.policy = policy;
        this.form = new PDAcroForm(destination);
    }

    public void mergeForm(PDAcroForm originalForm, LookupTable<PDAnnotation> annotationsLookup) {
        if (Objects.nonNull(originalForm)) {
            if (originalForm.hasXFA()) {
                LOG.warn("The AcroForm has XFA resurces which will be ignored");
            }
            LOG.debug("Merging acroforms with policy {}", (Object)this.policy);
            switch (this.policy) {
                case MERGE_RENAMING_EXISTING_FIELDS: {
                    this.updateForm(originalForm, annotationsLookup, this.createRenamingTerminalField, this.createRenamingNonTerminalField);
                    break;
                }
                case MERGE: {
                    this.updateForm(originalForm, annotationsLookup, this.createOrReuseTerminalField, this.createOrReuseNonTerminalField);
                    break;
                }
                case FLATTEN: {
                    this.updateForm(originalForm, annotationsLookup, this.createRenamingTerminalField, this.createRenamingNonTerminalField);
                    this.flatten();
                    break;
                }
                default: {
                    LOG.debug("Discarding acroform");
                    break;
                }
            }
        } else {
            LOG.debug("Skipped acroform merge, nothing to merge");
        }
    }

    private void removeFieldKeysFromWidgets(Collection<PDAnnotationWidget> annotations) {
        annotations.stream().map(PDDictionaryWrapper::getCOSObject).forEach(a -> {
            a.removeItems(FIELD_KEYS);
            if (annotations.size() == 1) {
                a.removeItem(COSName.DA);
            }
        });
        LOG.trace("Removed fields keys from widget annotations");
    }

    private void updateForm(PDAcroForm originalForm, LookupTable<PDAnnotation> annotationsLookup, BiFunction<PDTerminalField, LookupTable<PDField>, PDTerminalField> getTerminalField, BiConsumer<PDField, LookupTable<PDField>> createNonTerminalField) {
        AcroFormUtils.mergeDefaults(originalForm, this.form);
        LookupTable fieldsLookup = new LookupTable();
        originalForm.getFieldTree().stream().forEach(field -> {
            if (!field.isTerminal()) {
                createNonTerminalField.accept((PDField)field, (LookupTable<PDField>)fieldsLookup);
            } else {
                List<PDAnnotationWidget> relevantWidgets = this.findMappedWidgetsFor((PDTerminalField)field, annotationsLookup);
                if (!relevantWidgets.isEmpty()) {
                    PDTerminalField terminalField = (PDTerminalField)getTerminalField.apply((PDTerminalField)field, fieldsLookup);
                    if (Objects.nonNull(terminalField)) {
                        this.removeFieldKeysFromWidgets(relevantWidgets);
                        for (PDAnnotationWidget widget : relevantWidgets) {
                            terminalField.addWidgetIfMissing(widget);
                        }
                        terminalField.getCOSObject().removeItems(WIDGET_KEYS);
                    }
                } else {
                    LOG.debug("Discarded not relevant field {}", (Object)field.getFullyQualifiedName());
                }
            }
        });
        this.form.addFields(originalForm.getFields().stream().map(arg_0 -> ((LookupTable)fieldsLookup).lookup(arg_0)).filter(Objects::nonNull).collect(Collectors.toList()));
        annotationsLookup.values().stream().filter(a -> a instanceof PDAnnotationWidget).filter(a -> a.getCOSObject().containsKey(COSName.T)).map(a -> (PDAnnotationWidget)a).collect(Collectors.toList()).forEach(w -> {
            PDTerminalField newOrphanField;
            PDField orphanField = PDFieldFactory.createField((PDAcroForm)originalForm, (COSDictionary)w.getCOSObject(), null);
            if (orphanField instanceof PDTerminalField && Objects.nonNull(newOrphanField = (PDTerminalField)getTerminalField.apply((PDTerminalField)orphanField, fieldsLookup))) {
                w.getCOSObject().removeItems(FIELD_KEYS);
                newOrphanField.addWidgetIfMissing(w);
                newOrphanField.getCOSObject().removeItems(WIDGET_KEYS);
                if (Objects.isNull(this.getMergedField(newOrphanField.getFullyQualifiedName()))) {
                    this.form.addFields(Arrays.asList(newOrphanField));
                }
            }
        });
        this.mergeCalculationOrder(originalForm, (LookupTable<PDField>)fieldsLookup);
    }

    private void mergeCalculationOrder(PDAcroForm originalForm, LookupTable<PDField> fieldsLookup) {
        List co = originalForm.getCalculationOrder().stream().map(arg_0 -> fieldsLookup.lookup(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (Objects.nonNull(co) && co.size() > 0) {
            COSArray formCo = Optional.ofNullable(this.form.getCOSObject().getDictionaryObject(COSName.CO, COSArray.class)).orElseGet(COSArray::new);
            for (PDField field : co) {
                formCo.add((COSObjectable)field);
            }
            this.form.setCalculationOrder(formCo);
        }
    }

    private List<PDAnnotationWidget> findMappedWidgetsFor(PDTerminalField field, LookupTable<PDAnnotation> annotationsLookup) {
        return field.getWidgets().stream().map(arg_0 -> annotationsLookup.lookup(arg_0)).filter(w -> w instanceof PDAnnotationWidget).map(w -> (PDAnnotationWidget)w).collect(Collectors.toList());
    }

    private void flatten() {
        try {
            ArrayList<PDField> fields = new ArrayList<PDField>();
            for (PDField field : this.form.getFieldTree()) {
                fields.add(field);
                if (!(field instanceof PDVariableText)) continue;
                this.ensureValueCanBeDisplayed((PDVariableText)field);
            }
            this.form.flatten(fields, this.form.isNeedAppearances());
        }
        catch (IOException | UnsupportedOperationException ex) {
            LOG.warn("Failed to flatten form", (Throwable)ex);
        }
    }

    private void ensureValueCanBeDisplayed(PDVariableText field) throws IOException {
        String value = field.getValueAsString();
        if (!FontUtils.canDisplay(value, field.getAppearanceFont())) {
            PDFont fallbackFont = FontUtils.findFontFor(this.form.getDocument(), value);
            field.setAppearanceOverrideFont(fallbackFont);
            field.applyChange();
            LOG.debug("Form field can't render (in appearances) it's value '{}', will use font {} for better support", (Object)value, (Object)fallbackFont);
        }
    }

    public PDAcroForm getForm() {
        for (PDField current : this.form.getFieldTree()) {
            if (!current.isTerminal() && !((PDNonTerminalField)current).hasChildren()) {
                LOG.info("Removing non terminal field with no child {}", (Object)current.getFullyQualifiedName());
                if (Objects.nonNull(current.getParent())) {
                    current.getParent().removeChild(current);
                    continue;
                }
                this.form.removeField(current);
                continue;
            }
            if (!SignatureClipper.clipSignature(current)) continue;
            this.form.setSignaturesExist(true);
        }
        if (StringUtils.isBlank((CharSequence)this.form.getDefaultAppearance())) {
            this.form.setDefaultAppearance("/Helv 0 Tf 0 g ");
        }
        return this.form;
    }
}

