/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import org.sejda.common.ComponentsUtility;
import org.sejda.core.writer.context.ImageWriterContext;
import org.sejda.core.writer.model.ImageWriter;
import org.sejda.model.exception.TaskException;
import org.sejda.model.parameter.image.PdfToImageParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BasePdfToImageTask<T extends PdfToImageParameters>
extends BaseTask<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BasePdfToImageTask.class);
    private ImageWriter<T> writer;

    BasePdfToImageTask() {
    }

    public void before(T parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        this.writer = ImageWriterContext.getContext().createImageWriter(parameters);
        LOG.trace("Found image writer {}", this.writer);
    }

    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.writer);
    }

    ImageWriter<T> getWriter() {
        return this.writer;
    }
}

