/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.workarea;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.animation.FadeTransition;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.util.Duration;
import javax.inject.Inject;
import org.pdfsam.module.Module;
import org.pdfsam.ui.commons.SetActiveModuleRequest;
import org.pdfsam.ui.event.SetTitleEvent;
import org.pdfsam.ui.quickbar.QuickbarPane;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workarea.QuickbarModuleButtonsPane;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;

public class WorkArea
extends BorderPane {
    private Map<String, Module> modules = new HashMap<String, Module>();
    private Optional<Module> current = Optional.empty();
    private ScrollPane center = new ScrollPane();
    private FadeTransition fade = new FadeTransition(new Duration(300.0), (Node)this.center);

    @Inject
    public WorkArea(List<Module> modules, QuickbarModuleButtonsPane modulesButtons) {
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.setId("work-area");
        for (Module module : modules) {
            this.modules.put(module.id(), module);
        }
        this.fade.setFromValue(0.0);
        this.fade.setToValue(1.0);
        this.center.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.center.setFitToWidth(true);
        this.center.setFitToHeight(true);
        this.setCenter((Node)this.center);
        this.setLeft((Node)new QuickbarPane(modulesButtons));
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void onSetActiveModule(SetActiveModuleRequest request) {
        request.getActiveModuleId().ifPresent(id -> {
            Module requested = this.modules.get(id);
            if (requested != null) {
                this.current = Optional.of(requested);
                this.center.setContent((Node)requested.modulePanel());
                this.fade.play();
            }
        });
        StaticStudio.eventStudio().broadcast((Object)new SetTitleEvent(this.current.map(m -> m.descriptor().getName()).orElse("")));
    }
}

