/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.preference;

import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.ui.dashboard.preference.PreferenceBrowsableDirectoryField;
import org.pdfsam.ui.dashboard.preference.PreferenceBrowsableFileField;
import org.pdfsam.ui.dashboard.preference.PreferenceCheckBox;
import org.pdfsam.ui.help.HelpUtils;
import org.pdfsam.ui.support.FXValidationSupport;
import org.pdfsam.ui.support.Style;

class PreferenceWorkspacePane
extends VBox {
    @Inject
    public PreferenceWorkspacePane(@Named(value="workingDirectory") PreferenceBrowsableDirectoryField workingDirectory, @Named(value="workspace") PreferenceBrowsableFileField workspace, @Named(value="saveWorkspaceOnExit") PreferenceCheckBox saveWorkspaceOnExit, @Named(value="savePwdInWorkspace") PreferenceCheckBox savePwdInWorkspace) {
        I18nContext i18n = DefaultI18nContext.getInstance();
        workingDirectory.getTextField().setPromptText(i18n.i18n("Select a directory where documents will be saved and loaded by default"));
        workingDirectory.setBrowseWindowTitle(i18n.i18n("Select a directory"));
        HBox workigDirPane = new HBox(new Node[]{workingDirectory, HelpUtils.helpIcon((String)i18n.i18n("Select a directory where documents will be saved and loaded by default"))});
        HBox.setHgrow((Node)workingDirectory, (Priority)Priority.ALWAYS);
        workigDirPane.getStyleClass().add((Object)"with-help-hcontainer");
        workspace.getTextField().setPromptText(i18n.i18n("Select a previously saved workspace that will be automatically loaded at startup"));
        workspace.setBrowseWindowTitle(i18n.i18n("Select a workspace"));
        HBox workspaceDirPane = new HBox(new Node[]{workspace, HelpUtils.helpIcon((String)i18n.i18n("Select a previously saved workspace that will be automatically loaded at startup"))});
        HBox.setHgrow((Node)workspace, (Priority)Priority.ALWAYS);
        workspaceDirPane.getStyleClass().add((Object)"with-help-hcontainer");
        workspace.getTextField().validProperty().addListener((o, oldVal, newVal) -> saveWorkspaceOnExit.setDisable(StringUtils.isBlank((CharSequence)workspace.getTextField().getText()) || newVal != FXValidationSupport.ValidationState.VALID));
        workspace.getTextField().validate();
        this.getChildren().addAll((Object[])new Node[]{new Label(i18n.i18n("Default working directory:")), workigDirPane, new Label(i18n.i18n("Load default workspace at startup:")), workspaceDirPane, saveWorkspaceOnExit, savePwdInWorkspace});
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
    }
}

