/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.preference;

import javafx.scene.control.ComboBox;
import org.pdfsam.context.StringUserPreference;
import org.pdfsam.context.UserContext;
import org.pdfsam.support.KeyValueItem;
import org.pdfsam.support.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceComboBox<T extends KeyValueItem<String, String>>
extends ComboBox<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceComboBox.class);
    private StringUserPreference preference;

    public PreferenceComboBox(StringUserPreference preference, UserContext userContext) {
        RequireUtils.requireNotNull((Object)preference, (String)"Preference cannot be null");
        RequireUtils.requireNotNull((Object)userContext, (String)"UserContext cannot be null");
        this.preference = preference;
        this.valueProperty().addListener((observable, oldValue, newValue) -> {
            userContext.setStringPreference(this.preference, (String)newValue.getKey());
            LOG.trace("Preference {} set to {}", (Object)this.preference, newValue.getKey());
        });
    }
}

