/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.modules;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.utils.MaterialDesignIconFactory;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.pdfsam.module.Module;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfLoadRequestEvent;
import org.pdfsam.support.io.FileType;
import org.pdfsam.ui.commons.SetActiveModuleRequest;
import org.pdfsam.ui.commons.UrlButton;
import org.pdfsam.ui.dashboard.modules.DashboardTile;
import org.sejda.eventstudio.StaticStudio;

class ModulesDashboardTile
extends DashboardTile {
    private VBox toolButtons = new VBox(5.0);
    private String id;

    ModulesDashboardTile(Module module) {
        super(module.descriptor().getName(), module.descriptor().getDescription(), module.graphic());
        this.id = module.id();
        this.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> StaticStudio.eventStudio().broadcast((Object)SetActiveModuleRequest.activeteModule((String)this.id))));
        module.descriptor().getSupportURL().ifPresent(url -> {
            UrlButton helpButton = UrlButton.urlButton(null, (String)url, null, (String[])new String[]{"pdfsam-toolbar-button"});
            helpButton.setGraphic((Node)MaterialDesignIconFactory.get().createIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE, "1.4em"));
            this.toolButtons.getChildren().add((Object)helpButton);
            this.toolButtons.getStyleClass().add((Object)"dashboard-modules-toolbar");
            this.addBottomPanel((Region)this.toolButtons);
        });
        this.setOnDragOver(e -> this.dragConsume((DragEvent)e, this.onDragOverConsumer()));
        this.setOnDragDropped(e -> this.dragConsume((DragEvent)e, this.onDragDropped()));
    }

    private void dragConsume(DragEvent e, Consumer<DragEvent> c) {
        if (e.getDragboard().hasFiles()) {
            c.accept(e);
        }
        e.consume();
    }

    private Consumer<DragEvent> onDragOverConsumer() {
        return e -> e.acceptTransferModes(TransferMode.COPY_OR_MOVE);
    }

    private Consumer<DragEvent> onDragDropped() {
        return e -> {
            PdfLoadRequestEvent loadEvent = new PdfLoadRequestEvent(this.id);
            this.getFilesFromDragboard(e.getDragboard()).filter(f -> FileType.PDF.matches(f.getName())).map(PdfDocumentDescriptor::newDescriptorNoPassword).forEach(arg_0 -> ((PdfLoadRequestEvent)loadEvent).add(arg_0));
            if (!loadEvent.getDocuments().isEmpty()) {
                StaticStudio.eventStudio().broadcast((Object)SetActiveModuleRequest.activeteModule((String)this.id));
                StaticStudio.eventStudio().broadcast((Object)loadEvent, this.id);
            }
            e.setDropCompleted(true);
        };
    }

    private Stream<File> getFilesFromDragboard(Dragboard board) {
        List files = board.getFiles();
        if (files.size() == 1 && ((File)files.get(0)).isDirectory()) {
            return Arrays.stream(((File)files.get(0)).listFiles()).sorted();
        }
        return files.stream();
    }
}

