/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import java.awt.SplashScreen;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Application;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.pdfsam.ConfigurableProperty;
import org.pdfsam.InputPdfArgumentsController;
import org.pdfsam.Pdfsam;
import org.pdfsam.PdfsamConfig;
import org.pdfsam.Services;
import org.pdfsam.ShutdownEvent;
import org.pdfsam.UncaughtExceptionLogger;
import org.pdfsam.WindowStatusController;
import org.pdfsam.configuration.StylesConfig;
import org.pdfsam.context.DefaultUserContext;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.i18n.SetLocaleEvent;
import org.pdfsam.module.Module;
import org.pdfsam.news.FetchLatestNewsRequest;
import org.pdfsam.news.NewsService;
import org.pdfsam.premium.FetchPremiumModulesRequest;
import org.pdfsam.ui.MainPane;
import org.pdfsam.ui.SetLatestStageStatusRequest;
import org.pdfsam.ui.StageMode;
import org.pdfsam.ui.StageService;
import org.pdfsam.ui.StageStatus;
import org.pdfsam.ui.commons.OpenUrlRequest;
import org.pdfsam.ui.commons.SetActiveModuleRequest;
import org.pdfsam.ui.commons.ShowStageRequest;
import org.pdfsam.ui.dashboard.DashboardConfig;
import org.pdfsam.ui.dashboard.preference.PreferenceConfig;
import org.pdfsam.ui.dialog.ConfirmationDialog;
import org.pdfsam.ui.dialog.OpenWithDialog;
import org.pdfsam.ui.io.SetLatestDirectoryEvent;
import org.pdfsam.ui.log.LogMessageBroadcaster;
import org.pdfsam.ui.log.LoggerConfig;
import org.pdfsam.ui.module.OpenButton;
import org.pdfsam.ui.notification.NotificationsContainer;
import org.pdfsam.ui.workspace.LoadWorkspaceEvent;
import org.pdfsam.ui.workspace.SaveWorkspaceEvent;
import org.pdfsam.update.UpdateCheckRequest;
import org.sejda.core.Sejda;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.injector.Injector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfsamApp
extends Application {
    private static final Logger LOG = LoggerFactory.getLogger(PdfsamApp.class);
    private static StopWatch STOPWATCH = new StopWatch();
    private Stage primaryStage;
    private UserContext userContext = new DefaultUserContext();
    private List<String> rawParameters;
    private boolean clean;
    private Injector injector;
    private LogMessageBroadcaster broadcaster;

    public void init() {
        String defaultworkingPath;
        STOPWATCH.start();
        this.rawParameters = this.getParameters().getRaw();
        this.verboseIfRequired();
        this.startLogAppender();
        System.setProperty("sejda.sambox.asyncwriter", Boolean.TRUE.toString());
        System.setProperty("sejda.unethical.read", Boolean.TRUE.toString());
        LOG.info("Starting PDFsam");
        this.clean = this.rawParameters.contains("--clean") || this.rawParameters.contains("-clean") || this.rawParameters.contains("-c");
        this.cleanUserContextIfNeeded(this.userContext);
        String localeString = this.userContext.getLocale();
        if (StringUtils.isNotBlank((CharSequence)localeString)) {
            StaticStudio.eventStudio().broadcast((Object)new SetLocaleEvent(localeString));
        }
        if (StringUtils.isNotBlank((CharSequence)(defaultworkingPath = this.userContext.getDefaultWorkingPath()))) {
            try {
                if (Files.isDirectory(Paths.get(defaultworkingPath, new String[0]), new LinkOption[0])) {
                    StaticStudio.eventStudio().broadcast((Object)new SetLatestDirectoryEvent(new File(defaultworkingPath)));
                }
            }
            catch (InvalidPathException e) {
                LOG.warn("Unable to set initial directory, default path is invalid.", (Throwable)e);
            }
        }
    }

    private void verboseIfRequired() {
        if (this.rawParameters.contains("--verbose") || this.rawParameters.contains("-verbose") || this.rawParameters.contains("-v")) {
            ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"org.sejda")).setLevel(Level.DEBUG);
            ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"org.sejda.sambox")).setLevel(Level.DEBUG);
            ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"org.pdfsam")).setLevel(Level.DEBUG);
            ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"org.sejda.eventstudio")).setLevel(Level.INFO);
            LOG.info("Enabled verbose logging");
        }
    }

    private void cleanUserContextIfNeeded(UserContext userContext) {
        if (this.clean) {
            userContext.clear();
            LOG.info("Cleared user preferences");
        }
    }

    public void start(Stage primaryStage) {
        this.primaryStage = primaryStage;
        this.injector = this.initInjector();
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionLogger());
        this.initSejda();
        this.cleanIfRequired();
        primaryStage.setScene(this.initScene());
        primaryStage.getIcons().addAll((Collection)this.injector.instancesOfType(Image.class));
        primaryStage.setTitle(((Pdfsam)this.injector.instance(Pdfsam.class)).name());
        primaryStage.setOnCloseRequest(e -> Platform.exit());
        this.requestPremiumModulesDescriptionIfRequired();
        this.initWindowsStatusController(primaryStage);
        this.initDialogsOwner(primaryStage);
        this.initActiveModule();
        this.loadWorkspaceIfRequired();
        this.initOpenButtons();
        primaryStage.show();
        this.requestCheckForUpdateIfRequired();
        this.requestLatestNewsIfRequired();
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        this.closeSplash();
        STOPWATCH.stop();
        LOG.info(DefaultI18nContext.getInstance().i18n("Started in {0}", DurationFormatUtils.formatDurationWords((long)STOPWATCH.getTime(), (boolean)true, (boolean)true)));
        new InputPdfArgumentsController().accept(this.rawParameters);
    }

    private Injector initInjector() {
        Injector.addConfig((Object[])new Object[]{new PdfsamConfig(), new LoggerConfig(), new PreferenceConfig(), new DashboardConfig()});
        Services.initServices();
        return Injector.start();
    }

    private void initSejda() {
        Pdfsam pdfsam = (Pdfsam)this.injector.instance(Pdfsam.class);
        Sejda.CREATOR = pdfsam.shortName() + " v" + pdfsam.property(ConfigurableProperty.VERSION);
    }

    private void startLogAppender() {
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern("%-5level %nopex [%d{HH:mm:ss}]: %msg%n%xThrowable{50}");
        this.broadcaster = new LogMessageBroadcaster(encoder);
        this.broadcaster.start();
    }

    private void closeSplash() {
        Optional.ofNullable(SplashScreen.getSplashScreen()).ifPresent(SplashScreen::close);
    }

    private Scene initScene() {
        MainPane mainPane = (MainPane)((Object)this.injector.instance(MainPane.class));
        NotificationsContainer notifications = (NotificationsContainer)((Object)this.injector.instance(NotificationsContainer.class));
        StackPane main = new StackPane();
        StackPane.setAlignment((Node)notifications, (Pos)Pos.BOTTOM_RIGHT);
        StackPane.setAlignment((Node)mainPane, (Pos)Pos.TOP_LEFT);
        main.getChildren().addAll((Object[])new Node[]{mainPane, notifications});
        StylesConfig styles = (StylesConfig)this.injector.instance(StylesConfig.class);
        Scene mainScene = new Scene((Parent)main);
        mainScene.getStylesheets().addAll(styles.styles());
        mainScene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), () -> StaticStudio.eventStudio().broadcast((Object)ShowStageRequest.INSTANCE, "LogStage"));
        mainScene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.Q, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), () -> Platform.exit());
        return mainScene;
    }

    public void stop() {
        LOG.info(DefaultI18nContext.getInstance().i18n("Closing PDFsam..."));
        if (Objects.nonNull(this.primaryStage)) {
            StageStatus status = new StageStatus(this.primaryStage.getX(), this.primaryStage.getY(), this.primaryStage.getWidth(), this.primaryStage.getHeight());
            status.setMode(StageMode.valueFor((Stage)this.primaryStage));
            StaticStudio.eventStudio().broadcast((Object)new SetLatestStageStatusRequest(status));
        }
        this.saveWorkspaceIfRequired();
        StaticStudio.eventStudio().broadcast((Object)new ShutdownEvent());
        this.injector.close();
    }

    private void requestCheckForUpdateIfRequired() {
        if (((UserContext)this.injector.instance(UserContext.class)).isCheckForUpdates()) {
            StaticStudio.eventStudio().broadcast((Object)UpdateCheckRequest.INSTANCE);
        }
    }

    private void cleanIfRequired() {
        if (this.clean) {
            LOG.debug("Cleaning...");
            ((NewsService)this.injector.instance(NewsService.class)).clear();
            ((StageService)this.injector.instance(StageService.class)).clear();
        }
    }

    private void requestLatestNewsIfRequired() {
        if (((UserContext)this.injector.instance(UserContext.class)).isCheckForNews()) {
            StaticStudio.eventStudio().broadcast((Object)FetchLatestNewsRequest.INSTANCE);
        }
    }

    @EventListener
    public void openUrl(OpenUrlRequest event) {
        HostServices services = this.getHostServices();
        if (Objects.nonNull(services)) {
            try {
                services.showDocument(event.getUrl());
            }
            catch (NullPointerException npe) {
                LOG.info("Unable to open url using HostServices, trying fallback");
                try {
                    Runtime.getRuntime().exec(PdfsamApp.getOpenCmd(event.getUrl()));
                }
                catch (IOException e) {
                    LOG.warn("Unable to open the url", (Throwable)e);
                }
            }
        } else {
            LOG.warn("Unable to open '{}', please copy and paste the url to your browser.", (Object)event.getUrl());
        }
    }

    private void initDialogsOwner(Stage primaryStage) {
        this.injector.instancesOfType(ConfirmationDialog.class).stream().forEach(d -> d.setOwner((Window)primaryStage));
        ((OpenWithDialog)((Object)this.injector.instance(OpenWithDialog.class))).setOwner((Window)primaryStage);
    }

    private void initWindowsStatusController(Stage primaryStage) {
        ((WindowStatusController)this.injector.instance(WindowStatusController.class)).setStage(primaryStage);
    }

    private void initActiveModule() {
        String startupModule = this.userContext.getStartupModule();
        if (StringUtils.isNotBlank((CharSequence)startupModule)) {
            LOG.trace("Activating startup module '{}'", (Object)startupModule);
            StaticStudio.eventStudio().broadcast((Object)SetActiveModuleRequest.activeteModule((String)startupModule));
        }
    }

    private void initOpenButtons() {
        List modules = this.injector.instancesOfType(Module.class);
        List openButtons = this.injector.instancesOfType(OpenButton.class);
        for (OpenButton button : openButtons) {
            button.initModules((Collection)modules);
        }
    }

    private void requestPremiumModulesDescriptionIfRequired() {
        if (((UserContext)this.injector.instance(UserContext.class)).isFetchPremiumModules()) {
            StaticStudio.eventStudio().broadcast((Object)FetchPremiumModulesRequest.INSTANCE);
        }
    }

    private void loadWorkspaceIfRequired() {
        String workspace = Optional.ofNullable((String)this.getParameters().getNamed().get("workspace")).filter(StringUtils::isNotBlank).orElseGet(() -> ((UserContext)this.userContext).getDefaultWorkspacePath());
        if (StringUtils.isNotBlank((CharSequence)workspace) && Files.exists(Paths.get(workspace, new String[0]), new LinkOption[0])) {
            StaticStudio.eventStudio().broadcast((Object)new LoadWorkspaceEvent(new File(workspace)));
        }
    }

    private void saveWorkspaceIfRequired() {
        String workspace;
        if (this.userContext.isSaveWorkspaceOnExit() && StringUtils.isNotBlank((CharSequence)(workspace = this.userContext.getDefaultWorkspacePath())) && Files.exists(Paths.get(workspace, new String[0]), new LinkOption[0])) {
            StaticStudio.eventStudio().broadcast((Object)new SaveWorkspaceEvent(new File(workspace), true));
        }
    }

    public static String getOpenCmd(String url) throws IOException {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("mac") >= 0) {
            return String.format("%s %s", "open", url);
        }
        if (os.indexOf("win") >= 0) {
            return String.format("%s %s", "explorer", url);
        }
        if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0) {
            return String.format("%s %s", "xdg-open", url);
        }
        throw new IOException("Unable to identify the OS");
    }
}

