/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.HorizontalAlign;
import org.sejda.model.VerticalAlign;
import org.sejda.model.parameter.base.MultiplePdfSourceMultipleOutputParameters;
import org.sejda.model.pdf.StandardType1Font;
import org.sejda.model.pdf.numbering.BatesSequence;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PageRangeSelection;
import org.sejda.model.pdf.page.PagesSelection;
import org.sejda.model.pdf.page.PredefinedSetOfPages;
import org.sejda.model.validation.constraint.Positive;

public class SetHeaderFooterParameters
extends MultiplePdfSourceMultipleOutputParameters
implements PageRangeSelection,
PagesSelection {
    @NotNull
    @Valid
    private Set<PageRange> pageRanges = new HashSet<PageRange>();
    @NotNull
    private PredefinedSetOfPages predefinedSetOfPages = PredefinedSetOfPages.NONE;
    private StandardType1Font font = StandardType1Font.HELVETICA;
    private HorizontalAlign horizontalAlign = HorizontalAlign.CENTER;
    private VerticalAlign verticalAlign = VerticalAlign.BOTTOM;
    @Positive
    private double fontSize = 10.0;
    @NotNull
    private String pattern;
    private Integer pageCountStartFrom;
    private BatesSequence batesSequence;
    @NotNull
    private Color color = Color.black;
    private int fileCountStartFrom = 1;
    private boolean addMargins = false;

    public StandardType1Font getFont() {
        return this.font;
    }

    public void setFont(StandardType1Font font) {
        this.font = font;
    }

    public HorizontalAlign getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(HorizontalAlign align) {
        this.horizontalAlign = align;
    }

    public VerticalAlign getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(VerticalAlign verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Integer getPageCountStartFrom() {
        return this.pageCountStartFrom;
    }

    public void setPageCountStartFrom(int pageCountStartFrom) {
        this.pageCountStartFrom = pageCountStartFrom;
    }

    public BatesSequence getBatesSequence() {
        return this.batesSequence;
    }

    public void setBatesSequence(BatesSequence batesSequence) {
        this.batesSequence = batesSequence;
    }

    public void setFontSize(double fontSize) {
        this.fontSize = fontSize;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Integer getFileCountStartFrom() {
        return this.fileCountStartFrom;
    }

    public void setFileCountStartFrom(Integer fileCountStartFrom) {
        this.fileCountStartFrom = fileCountStartFrom;
    }

    public boolean isAddMargins() {
        return this.addMargins;
    }

    public void setAddMargins(boolean addMargins) {
        this.addMargins = addMargins;
    }

    public PredefinedSetOfPages getPredefinedSetOfPages() {
        return this.predefinedSetOfPages;
    }

    public void setPredefinedSetOfPages(PredefinedSetOfPages predefinedSetOfPages) {
        this.predefinedSetOfPages = predefinedSetOfPages;
    }

    public void addPageRange(PageRange range) {
        this.pageRanges.add(range);
    }

    public void addAllPageRanges(Collection<PageRange> ranges) {
        ranges.forEach(this::addPageRange);
    }

    @Override
    public Set<PageRange> getPageSelection() {
        return Collections.unmodifiableSet(this.pageRanges);
    }

    public Set<PageRange> getPageRanges() {
        return this.pageRanges;
    }

    public SortedSet<Integer> getPages(int upperLimit) {
        if (this.predefinedSetOfPages != PredefinedSetOfPages.NONE) {
            return this.predefinedSetOfPages.getPages(upperLimit);
        }
        TreeSet<Integer> retSet = new TreeSet<Integer>();
        for (PageRange range : this.getPageSelection()) {
            retSet.addAll(range.getPages(upperLimit));
        }
        return retSet;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.font).append((Object)this.horizontalAlign).append((Object)this.verticalAlign).append(this.fontSize).append(this.pageRanges).append((Object)this.pattern).append((Object)this.batesSequence).append((Object)this.pageCountStartFrom).append((Object)this.color).append(this.fileCountStartFrom).append(this.addMargins).append((Object)this.predefinedSetOfPages).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SetHeaderFooterParameters)) {
            return false;
        }
        SetHeaderFooterParameters parameter = (SetHeaderFooterParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getFont(), (Object)parameter.getFont()).append((Object)this.getHorizontalAlign(), (Object)parameter.getHorizontalAlign()).append((Object)this.getVerticalAlign(), (Object)parameter.getVerticalAlign()).append((Object)this.getBatesSequence(), (Object)parameter.getBatesSequence()).append((Object)this.getPageCountStartFrom(), (Object)parameter.getPageCountStartFrom()).append(this.getFontSize(), parameter.getFontSize()).append(this.getPageRanges(), parameter.getPageRanges()).append((Object)this.getPattern(), (Object)parameter.getPattern()).append((Object)this.getColor(), (Object)parameter.getColor()).append((Object)this.getFileCountStartFrom(), (Object)parameter.getFileCountStartFrom()).append(this.isAddMargins(), parameter.isAddMargins()).append((Object)this.getPredefinedSetOfPages(), (Object)parameter.getPredefinedSetOfPages()).isEquals();
    }
}

