/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.parameter.base.MultiplePdfSourceMultipleOutputParameters;
import org.sejda.model.pdf.PdfVersion;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.pdf.encryption.PdfEncryption;
import org.sejda.model.validation.constraint.HasAPassword;

@HasAPassword
public class EncryptParameters
extends MultiplePdfSourceMultipleOutputParameters {
    private String ownerPassword = "";
    private String userPassword = "";
    @NotNull
    private PdfEncryption encryptionAlgorithm = PdfEncryption.AES_ENC_256;
    private final Set<PdfAccessPermission> permissions = EnumSet.noneOf(PdfAccessPermission.class);

    public EncryptParameters(PdfEncryption encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public String getOwnerPassword() {
        return this.ownerPassword;
    }

    public void setOwnerPassword(String ownerPassword) {
        this.ownerPassword = ownerPassword;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public PdfEncryption getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public Set<PdfAccessPermission> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    public void clearPermissions() {
        this.permissions.clear();
    }

    public void addPermission(PdfAccessPermission permission) {
        this.permissions.add(permission);
    }

    @Override
    public PdfVersion getMinRequiredPdfVersion() {
        return PdfVersion.getMax(super.getMinRequiredPdfVersion(), this.encryptionAlgorithm.getMinVersion());
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.userPassword).append((Object)this.ownerPassword).append((Object)this.encryptionAlgorithm).append(this.permissions).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EncryptParameters)) {
            return false;
        }
        EncryptParameters parameter = (EncryptParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.userPassword, (Object)parameter.getUserPassword()).append((Object)this.ownerPassword, (Object)parameter.getOwnerPassword()).append((Object)this.encryptionAlgorithm, (Object)parameter.getEncryptionAlgorithm()).append(this.permissions, parameter.getPermissions()).isEquals();
    }
}

