/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.input;

import java.net.URL;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.AbstractPdfSource;
import org.sejda.model.input.PdfSourceOpener;

public final class PdfURLSource
extends AbstractPdfSource<URL> {
    @NotNull
    private final URL url;

    private PdfURLSource(URL url, String name, String password) {
        super(name, password);
        this.url = url;
    }

    @Override
    public URL getSource() {
        return this.url;
    }

    @Override
    public <T> T open(PdfSourceOpener<T> opener) throws TaskIOException {
        return opener.open(this);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append((Object)this.url).toString();
    }

    public static PdfURLSource newInstanceNoPassword(URL url, String name) {
        return PdfURLSource.newInstanceWithPassword(url, name, null);
    }

    public static PdfURLSource newInstanceWithPassword(URL url, String name, String password) {
        if (url == null) {
            throw new IllegalArgumentException("A not null url instance and a not blank name are expected.");
        }
        return new PdfURLSource(url, name, password);
    }
}

