/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple;

import java.util.Comparator;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import org.pdfsam.ui.selection.multiple.SelectionTableRowData;
import org.pdfsam.ui.selection.multiple.TableColumnProvider;

public interface SelectionTableColumn<T>
extends TableColumnProvider<T> {
    public String getColumnTitle();

    public Comparator<T> comparator();

    default public Callback<TableColumn<SelectionTableRowData, T>, TableCell<SelectionTableRowData, T>> cellFactory() {
        return new Callback<TableColumn<SelectionTableRowData, T>, TableCell<SelectionTableRowData, T>>(){

            public TableCell<SelectionTableRowData, T> call(TableColumn<SelectionTableRowData, T> param) {
                return new TableCell<SelectionTableRowData, T>(){

                    public void updateItem(T item, boolean empty) {
                        super.updateItem(item, empty);
                        if (empty || item == null) {
                            this.setText("");
                        } else {
                            this.setText(SelectionTableColumn.this.getTextValue(item));
                        }
                    }
                };
            }
        };
    }

    public String getTextValue(T var1);

    default public Callback<TableColumn.CellDataFeatures<SelectionTableRowData, T>, ObservableValue<T>> cellValueFactory() {
        return new Callback<TableColumn.CellDataFeatures<SelectionTableRowData, T>, ObservableValue<T>>(){

            public ObservableValue<T> call(TableColumn.CellDataFeatures<SelectionTableRowData, T> param) {
                if (param.getValue() != null) {
                    return SelectionTableColumn.this.getObservableValue((SelectionTableRowData)param.getValue());
                }
                return null;
            }
        };
    }

    public ObservableValue<T> getObservableValue(SelectionTableRowData var1);

    @Override
    default public TableColumn<SelectionTableRowData, T> getTableColumn() {
        TableColumn tableColumn = new TableColumn(this.getColumnTitle());
        tableColumn.setCellFactory(this.cellFactory());
        tableColumn.setCellValueFactory(this.cellValueFactory());
        tableColumn.setComparator(this.comparator());
        return tableColumn;
    }
}

