/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.rotate;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.rotate.RotateParametersBuilder;
import org.pdfsam.support.KeyStringValueItem;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.ui.ResettableView;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workspace.RestorableView;
import org.sejda.model.pdf.page.PredefinedSetOfPages;
import org.sejda.model.rotation.Rotation;

class RotateOptionsPane
extends HBox
implements TaskParametersBuildStep<RotateParametersBuilder>,
RestorableView,
ResettableView {
    private ComboBox<KeyStringValueItem<PredefinedSetOfPages>> rotationType = new ComboBox();
    private ComboBox<KeyStringValueItem<Rotation>> rotation = new ComboBox();

    RotateOptionsPane() {
        super(5.0);
        this.rotationType.getItems().add((Object)KeyStringValueItem.keyValue((Object)PredefinedSetOfPages.ALL_PAGES, (String)DefaultI18nContext.getInstance().i18n("All pages")));
        this.rotationType.getItems().add((Object)KeyStringValueItem.keyValue((Object)PredefinedSetOfPages.EVEN_PAGES, (String)DefaultI18nContext.getInstance().i18n("Even pages")));
        this.rotationType.getItems().add((Object)KeyStringValueItem.keyValue((Object)PredefinedSetOfPages.ODD_PAGES, (String)DefaultI18nContext.getInstance().i18n("Odd pages")));
        this.rotationType.setId("rotationType");
        this.rotation.getItems().add((Object)KeyStringValueItem.keyValue((Object)Rotation.DEGREES_90, (String)DefaultI18nContext.getInstance().i18n("90 degrees clockwise")));
        this.rotation.getItems().add((Object)KeyStringValueItem.keyValue((Object)Rotation.DEGREES_180, (String)DefaultI18nContext.getInstance().i18n("180 degrees clockwise")));
        this.rotation.getItems().add((Object)KeyStringValueItem.keyValue((Object)Rotation.DEGREES_270, (String)DefaultI18nContext.getInstance().i18n("90 degrees counterclockwise")));
        this.rotation.setId("rotation");
        this.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.resetView();
        this.getChildren().addAll((Object[])new Node[]{new Label(DefaultI18nContext.getInstance().i18n("Rotate ")), this.rotationType, this.rotation});
    }

    public void resetView() {
        this.rotationType.getSelectionModel().selectFirst();
        this.rotation.getSelectionModel().selectFirst();
    }

    public void apply(RotateParametersBuilder builder, Consumer<String> onError) {
        builder.rotation((Rotation)((KeyStringValueItem)this.rotation.getSelectionModel().getSelectedItem()).getKey());
        builder.rotationType((PredefinedSetOfPages)((KeyStringValueItem)this.rotationType.getSelectionModel().getSelectedItem()).getKey());
    }

    public void saveStateTo(Map<String, String> data) {
        data.put("rotation", Optional.ofNullable((KeyStringValueItem)this.rotation.getSelectionModel().getSelectedItem()).map(i -> ((Rotation)i.getKey()).toString()).orElse(""));
        data.put("rotationType", Optional.ofNullable((KeyStringValueItem)this.rotationType.getSelectionModel().getSelectedItem()).map(i -> ((PredefinedSetOfPages)i.getKey()).toString()).orElse(""));
    }

    public void restoreStateFrom(Map<String, String> data) {
        Optional.ofNullable(data.get("rotation")).map(Rotation::valueOf).map(r -> KeyStringValueItem.keyEmptyValue((Object)r)).ifPresent(r -> this.rotation.getSelectionModel().select(r));
        Optional.ofNullable(data.get("rotationType")).map(PredefinedSetOfPages::valueOf).map(r -> KeyStringValueItem.keyEmptyValue((Object)r)).ifPresent(r -> this.rotationType.getSelectionModel().select(r));
    }
}

