/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.i18n;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.i18n.SetLocaleEvent;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class DefaultI18nContext
implements I18nContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultI18nContext.class);
    public static final Set<Locale> SUPPORTED_LOCALES;
    private I18n i18n;

    DefaultI18nContext() {
        Locale.setDefault(this.getBestLocale());
        this.refreshBundles();
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    private void refreshBundles() {
        LOG.trace("Loading i18n bundle for {}", (Object)Locale.getDefault());
        this.i18n = I18nFactory.getI18n(DefaultI18nContext.class);
        LOG.debug("Locale set to {}", (Object)Locale.getDefault().getDisplayLanguage());
    }

    @EventListener
    public void refresh(SetLocaleEvent e) {
        String localeString = e.getLocaleString();
        if (StringUtils.isNotBlank((CharSequence)localeString)) {
            LOG.trace("Setting default locale to {}", (Object)localeString);
            Optional.ofNullable(Locale.forLanguageTag(localeString)).filter(SUPPORTED_LOCALES::contains).ifPresent(Locale::setDefault);
            this.refreshBundles();
        }
    }

    Locale getBestLocale() {
        if (SUPPORTED_LOCALES.contains(Locale.getDefault())) {
            return Locale.getDefault();
        }
        Locale onlyLanguage = new Locale(Locale.getDefault().getLanguage());
        if (SUPPORTED_LOCALES.contains(onlyLanguage)) {
            LOG.trace("Using supported locale closest to default {}", (Object)onlyLanguage);
            return onlyLanguage;
        }
        LOG.trace("Using fallback locale");
        return Locale.UK;
    }

    public static I18nContext getInstance() {
        return DefaultI18nContextHolder.CONTEXT;
    }

    @Override
    public String i18n(String input) {
        return this.i18n.tr(input);
    }

    @Override
    public String i18n(String input, String value) {
        return this.i18n.tr(input, (Object)value);
    }

    @Override
    public String i18n(String input, String value0, String value1) {
        return this.i18n.tr(input, (Object)value0, (Object)value1);
    }

    static {
        LinkedHashSet<Locale> supportedLocalesCache = new LinkedHashSet<Locale>();
        supportedLocalesCache.add(new Locale("eu"));
        supportedLocalesCache.add(new Locale("bs"));
        supportedLocalesCache.add(new Locale("pt", "BR"));
        supportedLocalesCache.add(new Locale("ca"));
        supportedLocalesCache.add(Locale.SIMPLIFIED_CHINESE);
        supportedLocalesCache.add(Locale.TRADITIONAL_CHINESE);
        supportedLocalesCache.add(new Locale("co"));
        supportedLocalesCache.add(new Locale("hr"));
        supportedLocalesCache.add(new Locale("cs"));
        supportedLocalesCache.add(new Locale("da"));
        supportedLocalesCache.add(new Locale("nl"));
        supportedLocalesCache.add(Locale.UK);
        supportedLocalesCache.add(Locale.FRENCH);
        supportedLocalesCache.add(Locale.GERMAN);
        supportedLocalesCache.add(new Locale("hu"));
        supportedLocalesCache.add(new Locale("el"));
        supportedLocalesCache.add(Locale.JAPANESE);
        supportedLocalesCache.add(Locale.ITALIAN);
        supportedLocalesCache.add(new Locale("pl"));
        supportedLocalesCache.add(new Locale("pt"));
        supportedLocalesCache.add(new Locale("ro"));
        supportedLocalesCache.add(new Locale("ru"));
        supportedLocalesCache.add(new Locale("sk"));
        supportedLocalesCache.add(new Locale("sl"));
        supportedLocalesCache.add(new Locale("es"));
        supportedLocalesCache.add(new Locale("tr"));
        supportedLocalesCache.add(new Locale("uk"));
        supportedLocalesCache.add(new Locale("fi"));
        SUPPORTED_LOCALES = Collections.unmodifiableSet(supportedLocalesCache);
    }

    private static final class DefaultI18nContextHolder {
        static final DefaultI18nContext CONTEXT = new DefaultI18nContext();

        private DefaultI18nContextHolder() {
        }
    }
}

