/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.support.io;

import javafx.stage.FileChooser;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;

public enum FileType {
    ALL{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.*)", new String[]{"*.*", "*"});
        }
    }
    ,
    CSV{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.csv)", new String[]{"*.csv", "*.CSV"});
        }
    }
    ,
    PDF{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.pdf)", new String[]{"*.pdf", "*.PDF"});
        }
    }
    ,
    TXT{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.txt)", new String[]{"*.txt", "*.TXT"});
        }
    }
    ,
    LOG{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.log, *.txt)", new String[]{"*.log", "*.txt", "*.LOG", "*.TXT"});
        }
    }
    ,
    XML{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.xml)", new String[]{"*.xml", "*.XML"});
        }
    }
    ,
    JSON{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.json)", new String[]{"*.json", "*.JSON"});
        }
    }
    ,
    HTML{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.html, *.htm)", new String[]{"*.htm", "*.html", "*.HTM", "*.HTML"});
        }
    };


    public abstract FileChooser.ExtensionFilter getFilter();

    public boolean matches(String filename) {
        for (String current : this.getFilter().getExtensions()) {
            if (!FilenameUtils.wildcardMatch((String)filename, (String)current, (IOCase)IOCase.INSENSITIVE)) continue;
            return true;
        }
        return false;
    }
}

