/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui;

import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.ShutdownEvent;
import org.pdfsam.support.LRUMap;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.ui.RecentWorkspacesService;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PreferencesRecentWorkspacesService
implements RecentWorkspacesService {
    private static final Logger LOG = LoggerFactory.getLogger(PreferencesRecentWorkspacesService.class);
    static final int MAX_CAPACITY = 5;
    static final String WORKSPACES_PATH = "/org/pdfsam/user/workspaces";
    private Map<String, String> cache = new LRUMap(5);

    public PreferencesRecentWorkspacesService() {
        this.populateCache();
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    private void populateCache() {
        Preferences prefs = Preferences.userRoot().node(WORKSPACES_PATH);
        try {
            Arrays.stream(prefs.keys()).sorted().forEach(k -> {
                String currentValue = prefs.get((String)k, "");
                if (StringUtils.isNotBlank((CharSequence)currentValue)) {
                    this.cache.put(currentValue, (String)k);
                }
            });
        }
        catch (BackingStoreException e) {
            LOG.error("Error retrieving recently used workspaces", (Throwable)e);
        }
    }

    @Override
    public void addWorkspaceLastUsed(File workspace) {
        RequireUtils.requireNotNull((Object)workspace, (String)"Null workspace is not allowed");
        this.cache.put(workspace.getAbsolutePath(), Long.toString(Instant.now().toEpochMilli()));
        LOG.trace("Added recently used workspace {}", (Object)workspace.getAbsolutePath());
    }

    @Override
    public List<String> getRecentlyUsedWorkspaces() {
        ArrayList<String> values = new ArrayList<String>(this.cache.keySet());
        Collections.reverse(values);
        return Collections.unmodifiableList(values);
    }

    @Override
    public void clear() {
        Preferences prefs = Preferences.userRoot().node(WORKSPACES_PATH);
        this.cache.clear();
        try {
            prefs.removeNode();
            prefs.flush();
        }
        catch (BackingStoreException e) {
            LOG.error("Unable to clear recently used workspaces", (Throwable)e);
        }
    }

    public void flush() {
        Preferences prefs = Preferences.userRoot().node(WORKSPACES_PATH);
        LOG.trace("Flushing recently used workspaces");
        try {
            prefs.clear();
            for (Map.Entry<String, String> entry : this.cache.entrySet()) {
                prefs.put(entry.getValue(), entry.getKey());
            }
            prefs.flush();
        }
        catch (BackingStoreException e) {
            LOG.error("Error storing recently used workspace", (Throwable)e);
        }
    }

    @EventListener
    public void onShutdown(ShutdownEvent event) {
        this.flush();
    }
}

