/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.ui.StageService;
import org.pdfsam.ui.StageStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultStageService
implements StageService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStageService.class);
    static final String STAGE_PATH = "/org/pdfsam/stage";
    static final String STAGE_STATUS_KEY = "stage.status";

    DefaultStageService() {
    }

    @Override
    public void save(StageStatus status) {
        Preferences node = Preferences.userRoot().node(STAGE_PATH);
        try {
            node.put(STAGE_STATUS_KEY, JSON.std.asString((Object)status));
            LOG.trace("Stage status saved {}", (Object)status);
        }
        catch (IOException e) {
            LOG.error("Unable to increment modules usage statistics", (Throwable)e);
        }
    }

    @Override
    public StageStatus getLatestStatus() {
        Preferences node = Preferences.userRoot().node(STAGE_PATH);
        try {
            String statusString = node.get(STAGE_STATUS_KEY, "");
            if (StringUtils.isNotBlank((CharSequence)statusString)) {
                return (StageStatus)JSON.std.beanFrom(StageStatus.class, (Object)statusString);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to get latest stage status", (Throwable)e);
        }
        return StageStatus.NULL;
    }

    @Override
    public void clear() {
        Preferences prefs = Preferences.userRoot().node(STAGE_PATH);
        try {
            prefs.removeNode();
            prefs.flush();
        }
        catch (BackingStoreException e) {
            LOG.error("Unable to clear stage status", (Throwable)e);
        }
    }
}

