/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.premium;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.premium.FetchPremiumModulesRequest;
import org.pdfsam.premium.PremiumModulesEvent;
import org.pdfsam.premium.PremiumModulesService;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.injector.Auto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class PremiumModulesController {
    private static final Logger LOG = LoggerFactory.getLogger(PremiumModulesController.class);
    private PremiumModulesService service;

    @Inject
    PremiumModulesController(PremiumModulesService service) {
        this.service = service;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void fetchPremium(FetchPremiumModulesRequest event) {
        LOG.debug(DefaultI18nContext.getInstance().i18n("Fetching premium modules"));
        ((CompletableFuture)CompletableFuture.supplyAsync(this.service::getPremiumModules).thenAcceptAsync(premiumModules -> {
            if (Objects.nonNull(premiumModules) && !premiumModules.isEmpty()) {
                StaticStudio.eventStudio().broadcast((Object)new PremiumModulesEvent(premiumModules));
            }
        })).whenComplete((r, e) -> {
            if (Objects.nonNull(e)) {
                LOG.warn(DefaultI18nContext.getInstance().i18n("Unable to retrieve premium modules"), e);
            }
        });
    }
}

