/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.pdf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.pdfsam.ShutdownEvent;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.Module;
import org.pdfsam.module.RequiredPdfData;
import org.pdfsam.pdf.PdfDescriptorLoadingStatus;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfFilesListLoadRequest;
import org.pdfsam.pdf.PdfListParser;
import org.pdfsam.pdf.PdfLoadRequestEvent;
import org.pdfsam.pdf.PdfLoadService;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.injector.Auto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class PdfLoadController {
    private static final Logger LOG = LoggerFactory.getLogger(PdfLoadController.class);
    private PdfLoadService loadService;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private Map<String, RequiredPdfData[]> requiredLoadData = new HashMap<String, RequiredPdfData[]>();

    @Inject
    public PdfLoadController(List<Module> modules, PdfLoadService loadService) {
        this.loadService = loadService;
        modules.forEach(m -> this.requiredLoadData.put(m.id(), m.requires()));
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void request(PdfLoadRequestEvent event) {
        LOG.trace("PDF load request received");
        event.getDocuments().forEach(i -> i.moveStatusTo(PdfDescriptorLoadingStatus.REQUESTED));
        this.executor.execute(() -> this.loadService.load(event.getDocuments(), this.requiredLoadData.get(event.getOwnerModule())));
    }

    @EventListener
    public void request(PdfFilesListLoadRequest event) {
        LOG.trace("PDF load from list request received");
        if (Objects.nonNull(event.list)) {
            this.executor.execute(() -> {
                try {
                    PdfLoadRequestEvent loadEvent = new PdfLoadRequestEvent(event.getOwnerModule());
                    new PdfListParser().apply(event.list).stream().map(PdfDocumentDescriptor::newDescriptorNoPassword).forEach(arg_0 -> ((PdfLoadRequestEvent)loadEvent).add(arg_0));
                    if (loadEvent.getDocuments().isEmpty()) {
                        LOG.error(DefaultI18nContext.getInstance().i18n("Unable to find any valid PDF file in the list: {0}", event.list.toString()));
                    } else {
                        StaticStudio.eventStudio().broadcast((Object)loadEvent, event.getOwnerModule());
                    }
                }
                catch (Exception e) {
                    LOG.error(DefaultI18nContext.getInstance().i18n("Unable to load PDF list file from {0}", event.list.toString()), (Throwable)e);
                }
            });
        }
    }

    @EventListener
    public void onShutdown(ShutdownEvent event) {
        this.executor.shutdownNow();
    }
}

