/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.module;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.ShutdownEvent;
import org.pdfsam.module.ModuleUsage;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PreferencesUsageDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(PreferencesUsageDataStore.class);
    static final String USAGE_PATH = "/org/pdfsam/modules/usage";
    static final String MODULE_USAGE_KEY = "module.usage";
    static final String TASKS_EXECUTED_KEY = "tasks.executed";

    public PreferencesUsageDataStore() {
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementUsageFor(String moduleId) {
        Preferences node = Preferences.userRoot().node(USAGE_PATH).node(moduleId);
        String json = node.get(MODULE_USAGE_KEY, "");
        try {
            if (StringUtils.isNotBlank((CharSequence)json)) {
                node.put(MODULE_USAGE_KEY, JSON.std.asString((Object)((ModuleUsage)JSON.std.beanFrom(ModuleUsage.class, (Object)json)).inc()));
            } else {
                node.put(MODULE_USAGE_KEY, JSON.std.asString((Object)ModuleUsage.fistUsage(moduleId)));
            }
            LOG.trace("Usage incremented for module {}", (Object)moduleId);
        }
        catch (IOException e) {
            LOG.error("Unable to increment modules usage statistics", (Throwable)e);
        }
        finally {
            this.incrementTotalUsage();
        }
    }

    public List<ModuleUsage> getUsages() {
        Preferences prefs = Preferences.userRoot().node(USAGE_PATH);
        ArrayList<ModuleUsage> retList = new ArrayList<ModuleUsage>();
        try {
            List jsons = ((Stream)Arrays.stream(prefs.childrenNames()).parallel()).map(name -> prefs.node((String)name)).map(node -> node.get(MODULE_USAGE_KEY, "")).filter(json -> StringUtils.isNotBlank((CharSequence)json)).collect(Collectors.toList());
            for (String json2 : jsons) {
                retList.add((ModuleUsage)JSON.std.beanFrom(ModuleUsage.class, (Object)json2));
            }
        }
        catch (IOException | BackingStoreException e) {
            LOG.error("Unable to get modules usage statistics", (Throwable)e);
        }
        return retList;
    }

    public void clear() {
        Preferences prefs = Preferences.userRoot().node(USAGE_PATH);
        try {
            prefs.removeNode();
            prefs.flush();
        }
        catch (BackingStoreException e) {
            LOG.error("Unable to clear modules usage statistics", (Throwable)e);
        }
    }

    private void incrementTotalUsage() {
        Preferences node = Preferences.userRoot().node(USAGE_PATH);
        node.putLong(TASKS_EXECUTED_KEY, node.getLong(TASKS_EXECUTED_KEY, 0L) + 1L);
    }

    public long getTotalUsage() {
        Preferences node = Preferences.userRoot().node(USAGE_PATH);
        return node.getLong(TASKS_EXECUTED_KEY, 0L);
    }

    @EventListener
    public void onShutdown(ShutdownEvent event) {
        this.flush();
    }

    public void flush() {
        Preferences prefs = Preferences.userRoot().node(USAGE_PATH);
        try {
            LOG.trace("Flushing modules usage");
            prefs.flush();
        }
        catch (BackingStoreException e) {
            LOG.error("Unable to flush modules usage statistics", (Throwable)e);
        }
    }
}

