/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.rendering;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.rendering.ImageType;
import org.sejda.sambox.rendering.PageDrawer;
import org.sejda.sambox.rendering.PageDrawerParameters;

public class PDFRenderer {
    protected final PDDocument document;

    public PDFRenderer(PDDocument document) {
        this.document = document;
    }

    public BufferedImage renderImage(int pageIndex) throws IOException {
        return this.renderImage(pageIndex, 1.0f);
    }

    public BufferedImage renderImage(int pageIndex, float scale) throws IOException {
        return this.renderImage(pageIndex, scale, ImageType.RGB);
    }

    public BufferedImage renderImageWithDPI(int pageIndex, float dpi) throws IOException {
        return this.renderImage(pageIndex, dpi / 72.0f, ImageType.RGB);
    }

    public BufferedImage renderImageWithDPI(int pageIndex, float dpi, ImageType imageType) throws IOException {
        return this.renderImage(pageIndex, dpi / 72.0f, imageType);
    }

    public BufferedImage renderImageWithDPI(int page, float dpi, int bufferedImageType) throws IOException {
        return this.renderImage(page, dpi / 72.0f, bufferedImageType);
    }

    public BufferedImage renderImage(int pageIndex, float scale, ImageType imageType) throws IOException {
        return this.renderImage(pageIndex, scale, imageType.toBufferedImageType());
    }

    public BufferedImage renderImage(int pageIndex, float scale, int bufferedImageType) throws IOException {
        PDPage page = this.document.getPage(pageIndex);
        PDRectangle cropbBox = page.getCropBox();
        float widthPt = cropbBox.getWidth();
        float heightPt = cropbBox.getHeight();
        int widthPx = Math.round(widthPt * scale);
        int heightPx = Math.round(heightPt * scale);
        int rotationAngle = page.getRotation();
        BufferedImage image = rotationAngle == 90 || rotationAngle == 270 ? new BufferedImage(heightPx, widthPx, bufferedImageType) : new BufferedImage(widthPx, heightPx, bufferedImageType);
        Graphics2D g = image.createGraphics();
        if (bufferedImageType == 2) {
            g.setBackground(new Color(0, 0, 0, 0));
        } else {
            g.setBackground(Color.WHITE);
        }
        g.clearRect(0, 0, image.getWidth(), image.getHeight());
        this.transform(g, page, scale);
        PageDrawerParameters parameters = new PageDrawerParameters(this, page);
        PageDrawer drawer = this.createPageDrawer(parameters);
        drawer.drawPage(g, page.getCropBox());
        g.dispose();
        return image;
    }

    public void renderPageToGraphics(int pageIndex, Graphics2D graphics) throws IOException {
        this.renderPageToGraphics(pageIndex, graphics, 1.0f);
    }

    public void renderPageToGraphics(int pageIndex, Graphics2D graphics, float scale) throws IOException {
        PDPage page = this.document.getPage(pageIndex);
        this.transform(graphics, page, scale);
        PDRectangle cropBox = page.getCropBox();
        graphics.clearRect(0, 0, (int)cropBox.getWidth(), (int)cropBox.getHeight());
        PageDrawerParameters parameters = new PageDrawerParameters(this, page);
        PageDrawer drawer = this.createPageDrawer(parameters);
        drawer.drawPage(graphics, cropBox);
    }

    private void transform(Graphics2D graphics, PDPage page, float scale) {
        graphics.scale(scale, scale);
        int rotationAngle = page.getRotation();
        PDRectangle cropBox = page.getCropBox();
        if (rotationAngle != 0) {
            float translateX = 0.0f;
            float translateY = 0.0f;
            switch (rotationAngle) {
                case 90: {
                    translateX = cropBox.getHeight();
                    break;
                }
                case 270: {
                    translateY = cropBox.getWidth();
                    break;
                }
                case 180: {
                    translateX = cropBox.getWidth();
                    translateY = cropBox.getHeight();
                    break;
                }
            }
            graphics.translate(translateX, translateY);
            graphics.rotate((float)Math.toRadians(rotationAngle));
        }
    }

    protected PageDrawer createPageDrawer(PageDrawerParameters parameters) throws IOException {
        return new PageDrawer(parameters);
    }
}

