/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.form;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import org.sejda.sambox.contentstream.PDContentStream;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.ResourceCache;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.common.PDStream;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDTransparencyGroupAttributes;
import org.sejda.sambox.util.Matrix;

public class PDFormXObject
extends PDXObject
implements PDContentStream {
    private PDTransparencyGroupAttributes group;
    private final ResourceCache cache;
    private PDResources resources;

    public PDFormXObject(PDStream stream) {
        super(stream, COSName.FORM);
        this.cache = null;
    }

    public PDFormXObject(COSStream stream) {
        super(stream, COSName.FORM);
        this.cache = null;
    }

    public PDFormXObject(COSStream stream, ResourceCache cache) {
        super(stream, COSName.FORM);
        this.cache = cache;
    }

    public PDFormXObject() {
        super(COSName.FORM);
        this.cache = null;
    }

    public int getFormType() {
        return this.getCOSObject().getInt(COSName.FORMTYPE, 1);
    }

    public void setFormType(int formType) {
        this.getCOSObject().setInt(COSName.FORMTYPE, formType);
    }

    public PDTransparencyGroupAttributes getGroup() {
        if (Objects.isNull(this.group)) {
            this.group = Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.GROUP, COSDictionary.class)).map(PDTransparencyGroupAttributes::new).orElse(null);
        }
        return this.group;
    }

    public void setGroup(PDTransparencyGroupAttributes group) {
        if (Objects.isNull(group)) {
            this.getCOSObject().removeItem(COSName.GROUP);
            this.group = null;
        } else {
            this.getCOSObject().setItem(COSName.GROUP, (COSBase)group.getCOSObject());
            this.group = group;
        }
    }

    public PDStream getContentStream() {
        return new PDStream(this.getCOSObject());
    }

    @Override
    public InputStream getContents() throws IOException {
        return this.getCOSObject().getUnfilteredStream();
    }

    @Override
    public PDResources getResources() {
        COSDictionary resourcesDict;
        if (this.resources == null && (resourcesDict = this.getCOSObject().getDictionaryObject(COSName.RESOURCES, COSDictionary.class)) != null) {
            this.resources = new PDResources(resourcesDict, this.cache);
        }
        return this.resources;
    }

    public void setResources(PDResources resources) {
        this.resources = resources;
        this.getCOSObject().setItem(COSName.RESOURCES, (COSObjectable)resources);
    }

    @Override
    public PDRectangle getBBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.getCOSObject().getDictionaryObject(COSName.BBOX);
        if (array != null && array.size() >= 4) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public void setBBox(PDRectangle bbox) {
        if (bbox == null) {
            this.getCOSObject().removeItem(COSName.BBOX);
        } else {
            this.getCOSObject().setItem(COSName.BBOX, (COSBase)bbox.getCOSObject());
        }
    }

    @Override
    public Matrix getMatrix() {
        COSArray array = (COSArray)this.getCOSObject().getDictionaryObject(COSName.MATRIX);
        if (array != null) {
            return new Matrix(array);
        }
        return new Matrix();
    }

    public void setMatrix(AffineTransform transform) {
        COSArray matrix = new COSArray();
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            matrix.add(new COSFloat((float)v));
        }
        this.getCOSObject().setItem(COSName.MATRIX, (COSBase)matrix);
    }

    public int getStructParents() {
        return this.getCOSObject().getInt(COSName.STRUCT_PARENTS, 0);
    }

    public void setStructParents(int structParent) {
        this.getCOSObject().setInt(COSName.STRUCT_PARENTS, structParent);
    }
}

