/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.IOException;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.output.IndirectObjectsWriter;
import org.sejda.sambox.output.PDFBodyObjectsWriter;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SyncPDFBodyObjectsWriter
implements PDFBodyObjectsWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SyncPDFBodyObjectsWriter.class);
    private IndirectObjectsWriter writer;

    SyncPDFBodyObjectsWriter(IndirectObjectsWriter writer) {
        RequireUtils.requireNotNullArg(writer, "Cannot write to a null writer");
        this.writer = writer;
    }

    @Override
    public void writeObject(IndirectCOSObjectReference ref) throws IOException {
        this.writer.writeObjectIfNotWritten(ref);
    }

    @Override
    public void onWriteCompletion() {
        LOG.debug("Written document body");
    }

    @Override
    public void close() {
    }
}

