/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.DeflaterInputStream;
import org.sejda.io.CountingWritableByteChannel;
import org.sejda.io.FastByteArrayOutputStream;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.DirectCOSObject;
import org.sejda.sambox.cos.DisposableCOSObject;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.cos.NonStorableInObjectStreams;
import org.sejda.sambox.output.DefaultCOSWriter;
import org.sejda.sambox.output.IndirectReferencesAwareCOSWriter;
import org.sejda.sambox.output.PDFBodyObjectsWriter;
import org.sejda.sambox.output.PDFWriteContext;
import org.sejda.sambox.xref.CompressedXrefEntry;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectsStreamPDFBodyObjectsWriter
implements PDFBodyObjectsWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectsStreamPDFBodyObjectsWriter.class);
    private PDFWriteContext context;
    private PDFBodyObjectsWriter delegate;
    private ObjectsStream currentStream;

    public ObjectsStreamPDFBodyObjectsWriter(PDFWriteContext context, PDFBodyObjectsWriter delegate) {
        RequireUtils.requireNotNullArg(context, "Write context cannot be null");
        RequireUtils.requireNotNullArg(delegate, "Delegate writer cannot be null");
        this.context = context;
        this.delegate = delegate;
        this.currentStream = new ObjectsStream(context);
        context.createIndirectReferenceFor(this.currentStream);
    }

    @Override
    public void writeObject(IndirectCOSObjectReference ref) throws IOException {
        if (ref instanceof NonStorableInObjectStreams || ref.getCOSObject().getCOSObject() instanceof COSStream) {
            this.delegate.writeObject(ref);
        } else {
            IndirectCOSObjectReference streamRef = this.context.getIndirectReferenceFor(this.currentStream);
            this.context.addWritten(CompressedXrefEntry.compressedEntry(ref.xrefEntry().getObjectNumber(), streamRef.xrefEntry().getObjectNumber(), this.currentStream.counter));
            this.currentStream.addItem(ref);
            LOG.trace("Added ref {} to object stream {}", (Object)ref, (Object)streamRef);
        }
        if (this.currentStream.isFull()) {
            this.doWriteObjectsStream();
            this.currentStream = new ObjectsStream(this.context);
            this.context.createIndirectReferenceFor(this.currentStream);
        }
    }

    private void doWriteObjectsStream() throws IOException {
        IndirectCOSObjectReference ref = this.context.getIndirectReferenceFor(this.currentStream);
        LOG.debug("Writing object stream {}", (Object)ref);
        this.currentStream.prepareForWriting();
        IndirectCOSObjectReference length = this.context.createNonStorableInObjectStreamIndirectReference();
        this.currentStream.setItem(COSName.LENGTH, (COSBase)length);
        this.delegate.writeObject(ref);
        LOG.trace("Writing object stream length {}", (Object)length);
        this.delegate.writeObject(length);
    }

    @Override
    public void onWriteCompletion() throws IOException {
        if (this.currentStream.hasItems()) {
            this.doWriteObjectsStream();
        }
        this.delegate.onWriteCompletion();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.delegate);
        this.currentStream = null;
    }

    static class ObjectsStream
    extends COSStream
    implements DisposableCOSObject {
        private int counter;
        private FastByteArrayOutputStream header = new FastByteArrayOutputStream();
        private FastByteArrayOutputStream data = new FastByteArrayOutputStream();
        private DefaultCOSWriter dataWriter;
        private InputStream filtered;

        public ObjectsStream(PDFWriteContext context) {
            this.setName(COSName.TYPE, COSName.OBJ_STM.getName());
            this.dataWriter = new IndirectReferencesAwareCOSWriter(CountingWritableByteChannel.from(this.data), context){

                @Override
                public void writeComplexObjectSeparator() {
                }

                @Override
                public void writeDictionaryItemsSeparator() {
                }
            };
        }

        public boolean hasItems() {
            return this.counter > 0;
        }

        void addItem(IndirectCOSObjectReference ref) throws IOException {
            ++this.counter;
            this.header.write(Long.toUnsignedString(ref.xrefEntry().getObjectNumber()).getBytes(StandardCharsets.US_ASCII));
            this.header.write(32);
            this.header.write(Long.toUnsignedString(this.dataWriter.writer().offset()).getBytes(StandardCharsets.US_ASCII));
            this.header.write(32);
            ref.getCOSObject().accept(this.dataWriter);
            this.dataWriter.writer().write((byte)32);
            ref.releaseCOSObject();
        }

        boolean isFull() {
            return this.counter >= Integer.getInteger("org.sejda.sambox.objects.stream.size", 100);
        }

        @Override
        public InputStream doGetFilteredStream() {
            return this.filtered;
        }

        void prepareForWriting() {
            IOUtils.closeQuietly(this.dataWriter);
            this.setItem(COSName.N, (COSBase)DirectCOSObject.asDirectObject(COSInteger.get(this.counter)));
            this.setItem(COSName.FIRST, (COSBase)DirectCOSObject.asDirectObject(COSInteger.get(this.header.size())));
            this.setItem(COSName.FILTER, (COSBase)DirectCOSObject.asDirectObject(COSName.FLATE_DECODE));
            this.filtered = new DeflaterInputStream(new SequenceInputStream(new ByteArrayInputStream(this.header.toByteArray()), new ByteArrayInputStream(this.data.toByteArray())));
            this.header = null;
            this.data = null;
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeQuietly(this.filtered);
            super.close();
        }

        @Override
        public void releaseCOSObject() {
            this.filtered = null;
        }
    }
}

