/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.input.AbstractXrefStreamParser;
import org.sejda.sambox.input.AbstractXrefTableParser;
import org.sejda.sambox.input.COSParser;
import org.sejda.sambox.input.ObjectsFullScanner;
import org.sejda.sambox.input.XrefFullScanner;
import org.sejda.sambox.xref.FileTrailer;
import org.sejda.sambox.xref.XrefEntry;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XrefParser {
    private static final Logger LOG = LoggerFactory.getLogger(XrefParser.class);
    private static final int DEFAULT_TRAIL_BYTECOUNT = 2048;
    private static final String STARTXREF = "startxref";
    private FileTrailer trailer = new FileTrailer();
    private AbstractXrefStreamParser xrefStreamParser;
    private AbstractXrefTableParser xrefTableParser;
    private COSParser parser;

    public XrefParser(COSParser parser) {
        this.parser = parser;
        this.xrefStreamParser = new AbstractXrefStreamParser(parser){

            @Override
            void onTrailerFound(COSDictionary found) {
                XrefParser.this.trailer.getCOSObject().mergeWithoutOverwriting(found);
            }

            @Override
            void onEntryFound(XrefEntry entry) {
                this.parser().provider().addEntryIfAbsent(entry);
            }
        };
        this.xrefTableParser = new AbstractXrefTableParser(parser){

            @Override
            void onTrailerFound(COSDictionary found) {
                XrefParser.this.trailer.getCOSObject().mergeWithoutOverwriting(found);
            }

            @Override
            void onEntryFound(XrefEntry entry) {
                this.parser().provider().addEntryIfAbsent(entry);
            }
        };
    }

    public void parse() throws IOException {
        long xrefOffset = this.findXrefOffset();
        if (xrefOffset <= 0L || !this.parseXref(xrefOffset)) {
            XrefFullScanner fallbackFullScanner = new XrefFullScanner(this.parser);
            XrefFullScanner.XrefScanOutcome xrefScanStatus = fallbackFullScanner.scan();
            if (xrefScanStatus != XrefFullScanner.XrefScanOutcome.NOT_FOUND) {
                this.trailer = fallbackFullScanner.trailer();
            }
            if (xrefScanStatus != XrefFullScanner.XrefScanOutcome.FOUND) {
                LOG.warn("Xref full scan encountered some errors, now performing objects full scan");
                ObjectsFullScanner objectsFullScanner = new ObjectsFullScanner(this.parser){
                    private long lastObjectOffset;
                    {
                        this.lastObjectOffset = 0L;
                    }

                    @Override
                    protected void onNonObjectDefinitionLine(long offset, String line) throws IOException {
                        if (Objects.nonNull(line)) {
                            if (line.startsWith("trailer")) {
                                LOG.debug("Parsing trailer at " + offset);
                                XrefParser.this.parser.position(offset);
                                XrefParser.this.parser.skipExpected("trailer");
                                XrefParser.this.parser.skipSpaces();
                                XrefParser.this.trailer.getCOSObject().merge(XrefParser.this.parser.nextDictionary());
                                XrefParser.this.parser.skipSpaces();
                            } else if (line.contains(COSName.CATALOG.getName())) {
                                long position = XrefParser.this.parser.position();
                                try {
                                    LOG.debug("Parsing potential Catalog at " + this.lastObjectOffset);
                                    XrefParser.this.parser.position(this.lastObjectOffset);
                                    XrefParser.this.parser.skipIndirectObjectDefinition();
                                    XrefParser.this.parser.skipSpaces();
                                    COSDictionary possibleCatalog = XrefParser.this.parser.nextDictionary();
                                    if (COSName.CATALOG.equals(possibleCatalog.getCOSName(COSName.TYPE))) {
                                        XrefParser.this.trailer.getCOSObject().putIfAbsent(COSName.ROOT, possibleCatalog);
                                    }
                                    XrefParser.this.parser.skipSpaces();
                                }
                                catch (IOException e) {
                                    LOG.warn("Unable to parse potential Catalog", e);
                                    XrefParser.this.parser.position(position);
                                }
                            } else if (line.startsWith("xref")) {
                                LOG.debug("Found xref at " + offset);
                                XrefParser.this.trailer.xrefOffset(offset);
                            }
                        }
                    }

                    @Override
                    protected void onObjectDefinitionLine(long offset, String line) {
                        this.lastObjectOffset = offset;
                    }
                };
                objectsFullScanner.entries().values().stream().forEach(this.parser.provider()::addEntry);
            }
        }
    }

    private final long findXrefOffset() throws IOException {
        int chunkSize = (int)Math.min(this.parser.length(), 2048L);
        long startPosition = this.parser.length() - (long)chunkSize;
        this.parser.position(startPosition);
        byte[] buffer = new byte[chunkSize];
        this.parser.source().read(ByteBuffer.wrap(buffer));
        int relativeIndex = new String(buffer, StandardCharsets.ISO_8859_1).lastIndexOf(STARTXREF);
        if (relativeIndex < 0) {
            LOG.warn("Unable to find 'startxref' keyword");
            return -1L;
        }
        try {
            this.parser.position(startPosition + (long)relativeIndex + (long)STARTXREF.length());
            this.parser.skipSpaces();
            long xrefOffset = this.parser.readLong();
            LOG.debug("Found xref offset at " + xrefOffset);
            return xrefOffset;
        }
        catch (IOException e) {
            LOG.warn("An error occurred while parsing the xref offset", e);
            return -1L;
        }
    }

    private boolean parseXref(long xrefOffset) {
        try {
            return this.doParseXref(xrefOffset);
        }
        catch (IOException e) {
            LOG.warn("An error occurred while parsing the xref, applying fallback strategy", e);
            return false;
        }
    }

    private boolean doParseXref(long xrefOffset) throws IOException {
        RequireUtils.requireIOCondition(this.isValidXrefOffset(xrefOffset), "Offset '" + xrefOffset + "' doesn't point to an xref table or stream");
        HashSet<Long> parsedOffsets = new HashSet<Long>();
        long currentOffset = xrefOffset;
        while (currentOffset > -1L) {
            RequireUtils.requireIOCondition(!parsedOffsets.contains(currentOffset), "/Prev loop detected");
            RequireUtils.requireIOCondition(this.isValidXrefOffset(currentOffset), "Offset '" + currentOffset + "' doesn't point to an xref table or stream");
            this.parser.position(currentOffset);
            this.parser.skipSpaces();
            if (this.parser.isNextToken("xref")) {
                COSDictionary trailer = this.xrefTableParser.parse(currentOffset);
                parsedOffsets.add(currentOffset);
                long streamOffset = trailer.getLong(COSName.XREF_STM);
                if (streamOffset > 0L) {
                    RequireUtils.requireIOCondition(this.isValidXrefStreamOffset(streamOffset), "Offset '" + streamOffset + "' doesn't point to an xref stream");
                    this.xrefStreamParser.parse(streamOffset);
                }
                currentOffset = trailer.getLong(COSName.PREV);
                continue;
            }
            COSDictionary streamDictionary = this.xrefStreamParser.parse(currentOffset);
            parsedOffsets.add(currentOffset);
            currentOffset = streamDictionary.getLong(COSName.PREV);
        }
        this.trailer.xrefOffset(xrefOffset);
        return true;
    }

    private boolean isValidXrefOffset(long xrefOffset) throws IOException {
        if (this.isValidXrefStreamOffset(xrefOffset)) {
            return true;
        }
        this.parser.position(xrefOffset);
        return this.parser.isNextToken("xref");
    }

    private boolean isValidXrefStreamOffset(long xrefStreamOffset) throws IOException {
        this.parser.position(xrefStreamOffset);
        try {
            this.parser.skipIndirectObjectDefinition();
            this.parser.skipSpaces();
            COSDictionary xrefStreamDictionary = this.parser.nextDictionary();
            this.parser.position(xrefStreamOffset);
            return COSName.XREF.equals(xrefStreamDictionary.getCOSName(COSName.TYPE));
        }
        catch (IOException exception) {
            return false;
        }
    }

    public FileTrailer trailer() {
        return this.trailer;
    }
}

