/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sejda.sambox.input.SourceReader;
import org.sejda.sambox.xref.Xref;
import org.sejda.sambox.xref.XrefEntry;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectsFullScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectsFullScanner.class);
    private static final Pattern OBJECT_DEF_PATTERN = Pattern.compile("^(\\d+)[\\s](\\d+)[\\s]obj");
    private Xref xref = new Xref();
    private SourceReader reader;
    private boolean scanned = false;

    ObjectsFullScanner(SourceReader reader) {
        RequireUtils.requireNotNullArg(reader, "Cannot read from a null reader");
        this.reader = reader;
    }

    private void scan() {
        LOG.info("Performing full scan to retrieve objects");
        try {
            long savedPos = this.reader.position();
            this.reader.position(0L);
            this.reader.skipSpaces();
            while (this.reader.source().peek() != -1) {
                long offset = this.reader.position();
                this.addEntryIfObjectDefinition(offset, this.reader.readLine());
                this.reader.skipSpaces();
            }
            this.reader.position(savedPos);
        }
        catch (IOException e) {
            LOG.error("An error occurred performing a full scan of the document", e);
        }
    }

    private void addEntryIfObjectDefinition(long offset, String line) throws IOException {
        Matcher matcher = OBJECT_DEF_PATTERN.matcher(line);
        if (matcher.find()) {
            this.xref.add(XrefEntry.inUseEntry(Long.parseUnsignedLong(matcher.group(1)), offset, Integer.parseUnsignedInt(matcher.group(2))));
            this.onObjectDefinitionLine(offset, line);
        } else {
            this.onNonObjectDefinitionLine(offset, line);
        }
    }

    protected void onNonObjectDefinitionLine(long originalOffset, String line) throws IOException {
    }

    protected void onObjectDefinitionLine(long originalOffset, String line) throws IOException {
    }

    Xref entries() {
        if (!this.scanned) {
            this.scanned = true;
            this.scan();
        }
        return this.xref;
    }
}

