/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import org.sejda.io.FastByteArrayOutputStream;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.filter.DecodeResult;
import org.sejda.sambox.filter.Filter;
import org.sejda.sambox.filter.Predictor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FlateFilter
extends Filter {
    private static final Logger LOG = LoggerFactory.getLogger(FlateFilter.class);
    private static final int BUFFER_SIZE = 16348;

    FlateFilter() {
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        int predictor = -1;
        COSDictionary decodeParams = this.getDecodeParams(parameters, index);
        if (decodeParams != null) {
            predictor = decodeParams.getInt(COSName.PREDICTOR);
        }
        try {
            if (predictor > 1) {
                int colors = Math.min(decodeParams.getInt(COSName.COLORS, 1), 32);
                int bitsPerPixel = decodeParams.getInt(COSName.BITS_PER_COMPONENT, 8);
                int columns = decodeParams.getInt(COSName.COLUMNS, 1);
                FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
                this.decompress(encoded, baos);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                Predictor.decodePredictor(predictor, colors, bitsPerPixel, columns, bais, decoded);
                decoded.flush();
                baos.reset();
                bais.reset();
            } else {
                this.decompress(encoded, decoded);
            }
        }
        catch (DataFormatException e) {
            LOG.error("FlateFilter: stop reading corrupt stream due to a DataFormatException");
            throw new IOException(e);
        }
        return new DecodeResult(parameters);
    }

    private void decompress(InputStream in, OutputStream out) throws IOException, DataFormatException {
        byte[] buf = new byte[2048];
        in.read(buf, 0, 2);
        int read = in.read(buf);
        if (read > 0) {
            Inflater inflater = new Inflater(true);
            inflater.setInput(buf, 0, read);
            byte[] res = new byte[1024];
            boolean dataWritten = false;
            while (true) {
                int resRead = 0;
                try {
                    resRead = inflater.inflate(res);
                }
                catch (DataFormatException exception) {
                    if (dataWritten) {
                        LOG.warn("FlateFilter: premature end of stream due to a DataFormatException");
                        break;
                    }
                    throw exception;
                }
                if (resRead != 0) {
                    out.write(res, 0, resRead);
                    dataWritten = true;
                    continue;
                }
                if (inflater.finished() || inflater.needsDictionary() || in.available() == 0) break;
                read = in.read(buf);
                inflater.setInput(buf, 0, read);
            }
            inflater.end();
        }
        out.flush();
    }

    @Override
    public void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        int compressionLevel = -1;
        try {
            compressionLevel = Integer.parseInt(System.getProperty("org.apache.pdfbox.filter.deflatelevel", "-1"));
        }
        catch (NumberFormatException ex) {
            LOG.warn(ex.getMessage(), ex);
        }
        compressionLevel = Math.max(-1, Math.min(9, compressionLevel));
        Deflater deflater = new Deflater(compressionLevel);
        DeflaterOutputStream out = new DeflaterOutputStream(encoded, deflater);
        int mayRead = input.available();
        if (mayRead > 0) {
            int amountRead;
            byte[] buffer = new byte[Math.min(mayRead, 16348)];
            while ((amountRead = input.read(buffer, 0, Math.min(mayRead, 16348))) != -1) {
                out.write(buffer, 0, amountRead);
            }
        }
        out.close();
        encoded.flush();
    }
}

