/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.filter.ASCII85InputStream;
import org.sejda.sambox.filter.ASCII85OutputStream;
import org.sejda.sambox.filter.DecodeResult;
import org.sejda.sambox.filter.Filter;

final class ASCII85Filter
extends Filter {
    ASCII85Filter() {
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        try (ASCII85InputStream is = new ASCII85InputStream(encoded);){
            IOUtils.copy((InputStream)is, decoded);
        }
        decoded.flush();
        return new DecodeResult(parameters);
    }

    @Override
    public void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        try (ASCII85OutputStream os = new ASCII85OutputStream(encoded);){
            IOUtils.copy(input, (OutputStream)os);
        }
        encoded.flush();
    }
}

